/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.TopPeerCategory;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.ResetTopPeerRating;

public final class ImmutableResetTopPeerRating
implements ResetTopPeerRating {
    private final int identifier;
    private final TopPeerCategory category;
    private final InputPeer peer;

    private ImmutableResetTopPeerRating(TopPeerCategory category, InputPeer peer) {
        this.category = Objects.requireNonNull(category, "category");
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = ResetTopPeerRating.super.identifier();
    }

    private ImmutableResetTopPeerRating(Builder builder) {
        this.category = builder.category;
        this.peer = builder.peer;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ResetTopPeerRating.super.identifier();
    }

    private ImmutableResetTopPeerRating(int identifier, TopPeerCategory category, InputPeer peer) {
        this.identifier = identifier;
        this.category = category;
        this.peer = peer;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public TopPeerCategory category() {
        return this.category;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    public final ImmutableResetTopPeerRating withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableResetTopPeerRating(value, this.category, this.peer);
    }

    public final ImmutableResetTopPeerRating withCategory(TopPeerCategory value) {
        TopPeerCategory newValue = Objects.requireNonNull(value, "category");
        if (this.category == newValue) {
            return this;
        }
        return new ImmutableResetTopPeerRating(this.identifier, newValue, this.peer);
    }

    public final ImmutableResetTopPeerRating withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableResetTopPeerRating(this.identifier, this.category, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResetTopPeerRating && this.equalTo(0, (ImmutableResetTopPeerRating)another);
    }

    private boolean equalTo(int synthetic, ImmutableResetTopPeerRating another) {
        return this.identifier == another.identifier && this.category.equals((Object)another.category) && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.category.hashCode();
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "ResetTopPeerRating{identifier=" + this.identifier + ", category=" + this.category + ", peer=" + this.peer + "}";
    }

    public static ImmutableResetTopPeerRating of(TopPeerCategory category, InputPeer peer) {
        return new ImmutableResetTopPeerRating(category, peer);
    }

    public static ImmutableResetTopPeerRating copyOf(ResetTopPeerRating instance) {
        if (instance instanceof ImmutableResetTopPeerRating) {
            return (ImmutableResetTopPeerRating)instance;
        }
        return ImmutableResetTopPeerRating.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CATEGORY = 1L;
        private static final long INIT_BIT_PEER = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private TopPeerCategory category;
        private InputPeer peer;

        private Builder() {
        }

        public final Builder from(ResetTopPeerRating instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ResetTopPeerRating instance;
            long bits = 0L;
            if (object instanceof ResetTopPeerRating) {
                instance = (ResetTopPeerRating)object;
                this.category(instance.category());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder category(TopPeerCategory category) {
            this.category = Objects.requireNonNull(category, "category");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableResetTopPeerRating build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResetTopPeerRating(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("category");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build ResetTopPeerRating, some of required attributes are not set " + attributes;
        }
    }
}

