/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.ResolvePhone;

public final class ImmutableResolvePhone
implements ResolvePhone {
    private final int identifier;
    private final String phone;

    private ImmutableResolvePhone(String phone) {
        this.phone = Objects.requireNonNull(phone, "phone");
        this.identifier = ResolvePhone.super.identifier();
    }

    private ImmutableResolvePhone(Builder builder) {
        this.phone = builder.phone;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ResolvePhone.super.identifier();
    }

    private ImmutableResolvePhone(int identifier, String phone) {
        this.identifier = identifier;
        this.phone = phone;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phone() {
        return this.phone;
    }

    public final ImmutableResolvePhone withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableResolvePhone(value, this.phone);
    }

    public final ImmutableResolvePhone withPhone(String value) {
        String newValue = Objects.requireNonNull(value, "phone");
        if (this.phone.equals(newValue)) {
            return this;
        }
        return new ImmutableResolvePhone(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResolvePhone && this.equalTo(0, (ImmutableResolvePhone)another);
    }

    private boolean equalTo(int synthetic, ImmutableResolvePhone another) {
        return this.identifier == another.identifier && this.phone.equals(another.phone);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phone.hashCode();
        return h;
    }

    public String toString() {
        return "ResolvePhone{identifier=" + this.identifier + ", phone=" + this.phone + "}";
    }

    public static ImmutableResolvePhone of(String phone) {
        return new ImmutableResolvePhone(phone);
    }

    public static ImmutableResolvePhone copyOf(ResolvePhone instance) {
        if (instance instanceof ImmutableResolvePhone) {
            return (ImmutableResolvePhone)instance;
        }
        return ImmutableResolvePhone.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String phone;

        private Builder() {
        }

        public final Builder from(ResolvePhone instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ResolvePhone instance;
            long bits = 0L;
            if (object instanceof ResolvePhone) {
                instance = (ResolvePhone)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phone(instance.phone());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phone(String phone) {
            this.phone = Objects.requireNonNull(phone, "phone");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableResolvePhone build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResolvePhone(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phone");
            }
            return "Cannot build ResolvePhone, some of required attributes are not set " + attributes;
        }
    }
}

