/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.ResolveUsername;

public final class ImmutableResolveUsername
implements ResolveUsername {
    private final int identifier;
    private final String username;

    private ImmutableResolveUsername(String username) {
        this.username = Objects.requireNonNull(username, "username");
        this.identifier = ResolveUsername.super.identifier();
    }

    private ImmutableResolveUsername(Builder builder) {
        this.username = builder.username;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ResolveUsername.super.identifier();
    }

    private ImmutableResolveUsername(int identifier, String username) {
        this.identifier = identifier;
        this.username = username;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String username() {
        return this.username;
    }

    public final ImmutableResolveUsername withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableResolveUsername(value, this.username);
    }

    public final ImmutableResolveUsername withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableResolveUsername(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResolveUsername && this.equalTo(0, (ImmutableResolveUsername)another);
    }

    private boolean equalTo(int synthetic, ImmutableResolveUsername another) {
        return this.identifier == another.identifier && this.username.equals(another.username);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.username.hashCode();
        return h;
    }

    public String toString() {
        return "ResolveUsername{identifier=" + this.identifier + ", username=" + this.username + "}";
    }

    public static ImmutableResolveUsername of(String username) {
        return new ImmutableResolveUsername(username);
    }

    public static ImmutableResolveUsername copyOf(ResolveUsername instance) {
        if (instance instanceof ImmutableResolveUsername) {
            return (ImmutableResolveUsername)instance;
        }
        return ImmutableResolveUsername.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String username;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ResolveUsername instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ResolveUsername) {
                instance = (ResolveUsername)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.username(instance.username());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableResolveUsername build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResolveUsername(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            return "Cannot build ResolveUsername, some of required attributes are not set " + attributes;
        }
    }
}

