/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.Search;

public final class ImmutableSearch
implements Search {
    private final int identifier;
    private final String q;
    private final int limit;

    private ImmutableSearch(String q, int limit) {
        this.q = Objects.requireNonNull(q, "q");
        this.limit = limit;
        this.identifier = Search.super.identifier();
    }

    private ImmutableSearch(Builder builder) {
        this.q = builder.q;
        this.limit = builder.limit;
        this.identifier = builder.identifierIsSet() ? builder.identifier : Search.super.identifier();
    }

    private ImmutableSearch(int identifier, String q, int limit) {
        this.identifier = identifier;
        this.q = q;
        this.limit = limit;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String q() {
        return this.q;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableSearch withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSearch(value, this.q, this.limit);
    }

    public final ImmutableSearch withQ(String value) {
        String newValue = Objects.requireNonNull(value, "q");
        if (this.q.equals(newValue)) {
            return this;
        }
        return new ImmutableSearch(this.identifier, newValue, this.limit);
    }

    public final ImmutableSearch withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableSearch(this.identifier, this.q, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearch && this.equalTo(0, (ImmutableSearch)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearch another) {
        return this.identifier == another.identifier && this.q.equals(another.q) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.q.hashCode();
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "Search{identifier=" + this.identifier + ", q=" + this.q + ", limit=" + this.limit + "}";
    }

    public static ImmutableSearch of(String q, int limit) {
        return new ImmutableSearch(q, limit);
    }

    public static ImmutableSearch copyOf(Search instance) {
        if (instance instanceof ImmutableSearch) {
            return (ImmutableSearch)instance;
        }
        return ImmutableSearch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_Q = 1L;
        private static final long INIT_BIT_LIMIT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String q;
        private int limit;

        private Builder() {
        }

        public final Builder from(Search instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Search instance;
            long bits = 0L;
            if (object instanceof Search) {
                instance = (Search)object;
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.q(instance.q());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder q(String q) {
            this.q = Objects.requireNonNull(q, "q");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSearch build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSearch(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("q");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build Search, some of required attributes are not set " + attributes;
        }
    }
}

