/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.ToggleTopPeers;

public final class ImmutableToggleTopPeers
implements ToggleTopPeers {
    private final int identifier;
    private final boolean enabled;

    private ImmutableToggleTopPeers(boolean enabled) {
        this.enabled = enabled;
        this.identifier = ToggleTopPeers.super.identifier();
    }

    private ImmutableToggleTopPeers(Builder builder) {
        this.enabled = builder.enabled;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ToggleTopPeers.super.identifier();
    }

    private ImmutableToggleTopPeers(int identifier, boolean enabled) {
        this.identifier = identifier;
        this.enabled = enabled;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    public final ImmutableToggleTopPeers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableToggleTopPeers(value, this.enabled);
    }

    public final ImmutableToggleTopPeers withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableToggleTopPeers(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToggleTopPeers && this.equalTo(0, (ImmutableToggleTopPeers)another);
    }

    private boolean equalTo(int synthetic, ImmutableToggleTopPeers another) {
        return this.identifier == another.identifier && this.enabled == another.enabled;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Boolean.hashCode(this.enabled);
        return h;
    }

    public String toString() {
        return "ToggleTopPeers{identifier=" + this.identifier + ", enabled=" + this.enabled + "}";
    }

    public static ImmutableToggleTopPeers of(boolean enabled) {
        return new ImmutableToggleTopPeers(enabled);
    }

    public static ImmutableToggleTopPeers copyOf(ToggleTopPeers instance) {
        if (instance instanceof ImmutableToggleTopPeers) {
            return (ImmutableToggleTopPeers)instance;
        }
        return ImmutableToggleTopPeers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ENABLED = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private boolean enabled;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ToggleTopPeers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ToggleTopPeers) {
                instance = (ToggleTopPeers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.enabled(instance.enabled());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableToggleTopPeers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToggleTopPeers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enabled");
            }
            return "Cannot build ToggleTopPeers, some of required attributes are not set " + attributes;
        }
    }
}

