/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.contacts;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.contacts.Unblock;

public final class ImmutableUnblock
implements Unblock {
    private final int identifier;
    private final InputPeer id;

    private ImmutableUnblock(InputPeer id) {
        this.id = Objects.requireNonNull(id, "id");
        this.identifier = Unblock.super.identifier();
    }

    private ImmutableUnblock(Builder builder) {
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : Unblock.super.identifier();
    }

    private ImmutableUnblock(int identifier, InputPeer id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer id() {
        return this.id;
    }

    public final ImmutableUnblock withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUnblock(value, this.id);
    }

    public final ImmutableUnblock withId(InputPeer value) {
        if (this.id == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "id");
        return new ImmutableUnblock(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUnblock && this.equalTo(0, (ImmutableUnblock)another);
    }

    private boolean equalTo(int synthetic, ImmutableUnblock another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "Unblock{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableUnblock of(InputPeer id) {
        return new ImmutableUnblock(id);
    }

    public static ImmutableUnblock copyOf(Unblock instance) {
        if (instance instanceof ImmutableUnblock) {
            return (ImmutableUnblock)instance;
        }
        return ImmutableUnblock.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPeer id;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Unblock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Unblock) {
                instance = (Unblock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(InputPeer id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUnblock build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUnblock(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Unblock, some of required attributes are not set " + attributes;
        }
    }
}

