/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.folders;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.folders.DeleteFolder;

public final class ImmutableDeleteFolder
implements DeleteFolder {
    private final int identifier;
    private final int folderId;

    private ImmutableDeleteFolder(int folderId) {
        this.folderId = folderId;
        this.identifier = DeleteFolder.super.identifier();
    }

    private ImmutableDeleteFolder(Builder builder) {
        this.folderId = builder.folderId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : DeleteFolder.super.identifier();
    }

    private ImmutableDeleteFolder(int identifier, int folderId) {
        this.identifier = identifier;
        this.folderId = folderId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int folderId() {
        return this.folderId;
    }

    public final ImmutableDeleteFolder withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDeleteFolder(value, this.folderId);
    }

    public final ImmutableDeleteFolder withFolderId(int value) {
        if (this.folderId == value) {
            return this;
        }
        return new ImmutableDeleteFolder(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteFolder && this.equalTo(0, (ImmutableDeleteFolder)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteFolder another) {
        return this.identifier == another.identifier && this.folderId == another.folderId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.folderId;
        return h;
    }

    public String toString() {
        return "DeleteFolder{identifier=" + this.identifier + ", folderId=" + this.folderId + "}";
    }

    public static ImmutableDeleteFolder of(int folderId) {
        return new ImmutableDeleteFolder(folderId);
    }

    public static ImmutableDeleteFolder copyOf(DeleteFolder instance) {
        if (instance instanceof ImmutableDeleteFolder) {
            return (ImmutableDeleteFolder)instance;
        }
        return ImmutableDeleteFolder.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FOLDER_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int folderId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DeleteFolder instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DeleteFolder) {
                instance = (DeleteFolder)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.folderId(instance.folderId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder folderId(int folderId) {
            this.folderId = folderId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDeleteFolder build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeleteFolder(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("folderId");
            }
            return "Cannot build DeleteFolder, some of required attributes are not set " + attributes;
        }
    }
}

