/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.folders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputFolderPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.folders.EditPeerFolders;

public final class ImmutableEditPeerFolders
implements EditPeerFolders {
    private final int identifier;
    private final List<InputFolderPeer> folderPeers;

    private ImmutableEditPeerFolders(Builder builder) {
        this.folderPeers = ImmutableEditPeerFolders.createUnmodifiableList(true, builder.folderPeers);
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditPeerFolders.super.identifier();
    }

    private ImmutableEditPeerFolders(int identifier, List<InputFolderPeer> folderPeers) {
        this.identifier = identifier;
        this.folderPeers = folderPeers;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<InputFolderPeer> folderPeers() {
        return this.folderPeers;
    }

    public final ImmutableEditPeerFolders withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditPeerFolders(value, this.folderPeers);
    }

    public final ImmutableEditPeerFolders withFolderPeers(InputFolderPeer ... elements) {
        List<InputFolderPeer> newValue = ImmutableEditPeerFolders.createUnmodifiableList(false, ImmutableEditPeerFolders.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEditPeerFolders(this.identifier, newValue);
    }

    public final ImmutableEditPeerFolders withFolderPeers(Iterable<? extends InputFolderPeer> elements) {
        if (this.folderPeers == elements) {
            return this;
        }
        List<InputFolderPeer> newValue = ImmutableEditPeerFolders.createUnmodifiableList(false, ImmutableEditPeerFolders.createSafeList(elements, true, false));
        return new ImmutableEditPeerFolders(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditPeerFolders && this.equalTo(0, (ImmutableEditPeerFolders)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditPeerFolders another) {
        return this.identifier == another.identifier && this.folderPeers.equals(another.folderPeers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.folderPeers.hashCode();
        return h;
    }

    public String toString() {
        return "EditPeerFolders{identifier=" + this.identifier + ", folderPeers=" + this.folderPeers + "}";
    }

    public static ImmutableEditPeerFolders copyOf(EditPeerFolders instance) {
        if (instance instanceof ImmutableEditPeerFolders) {
            return (ImmutableEditPeerFolders)instance;
        }
        return ImmutableEditPeerFolders.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<InputFolderPeer> folderPeers = new ArrayList<InputFolderPeer>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EditPeerFolders instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EditPeerFolders) {
                instance = (EditPeerFolders)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllFolderPeers(instance.folderPeers());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFolderPeer(InputFolderPeer element) {
            this.folderPeers.add(Objects.requireNonNull(element, "folderPeers element"));
            return this;
        }

        public final Builder addFolderPeers(InputFolderPeer ... elements) {
            for (InputFolderPeer element : elements) {
                this.folderPeers.add(Objects.requireNonNull(element, "folderPeers element"));
            }
            return this;
        }

        public final Builder folderPeers(Iterable<? extends InputFolderPeer> elements) {
            this.folderPeers.clear();
            return this.addAllFolderPeers(elements);
        }

        public final Builder addAllFolderPeers(Iterable<? extends InputFolderPeer> elements) {
            for (InputFolderPeer inputFolderPeer : elements) {
                this.folderPeers.add(Objects.requireNonNull(inputFolderPeer, "folderPeers element"));
            }
            return this;
        }

        public ImmutableEditPeerFolders build() {
            return new ImmutableEditPeerFolders(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

