/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.help.AcceptTermsOfService;

public final class ImmutableAcceptTermsOfService
implements AcceptTermsOfService {
    private final int identifier;
    private final DataJSON id;

    private ImmutableAcceptTermsOfService(DataJSON id) {
        this.id = Objects.requireNonNull(id, "id");
        this.identifier = AcceptTermsOfService.super.identifier();
    }

    private ImmutableAcceptTermsOfService(Builder builder) {
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : AcceptTermsOfService.super.identifier();
    }

    private ImmutableAcceptTermsOfService(int identifier, DataJSON id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public DataJSON id() {
        return this.id;
    }

    public final ImmutableAcceptTermsOfService withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAcceptTermsOfService(value, this.id);
    }

    public final ImmutableAcceptTermsOfService withId(DataJSON value) {
        if (this.id == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "id");
        return new ImmutableAcceptTermsOfService(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAcceptTermsOfService && this.equalTo(0, (ImmutableAcceptTermsOfService)another);
    }

    private boolean equalTo(int synthetic, ImmutableAcceptTermsOfService another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "AcceptTermsOfService{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableAcceptTermsOfService of(DataJSON id) {
        return new ImmutableAcceptTermsOfService(id);
    }

    public static ImmutableAcceptTermsOfService copyOf(AcceptTermsOfService instance) {
        if (instance instanceof ImmutableAcceptTermsOfService) {
            return (ImmutableAcceptTermsOfService)instance;
        }
        return ImmutableAcceptTermsOfService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private DataJSON id;

        private Builder() {
        }

        public final Builder from(AcceptTermsOfService instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AcceptTermsOfService instance;
            long bits = 0L;
            if (object instanceof AcceptTermsOfService) {
                instance = (AcceptTermsOfService)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(DataJSON id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableAcceptTermsOfService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAcceptTermsOfService(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build AcceptTermsOfService, some of required attributes are not set " + attributes;
        }
    }
}

