/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.help.DismissSuggestion;

public final class ImmutableDismissSuggestion
implements DismissSuggestion {
    private final int identifier;
    private final InputPeer peer;
    private final String suggestion;

    private ImmutableDismissSuggestion(InputPeer peer, String suggestion) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.suggestion = Objects.requireNonNull(suggestion, "suggestion");
        this.identifier = DismissSuggestion.super.identifier();
    }

    private ImmutableDismissSuggestion(Builder builder) {
        this.peer = builder.peer;
        this.suggestion = builder.suggestion;
        this.identifier = builder.identifierIsSet() ? builder.identifier : DismissSuggestion.super.identifier();
    }

    private ImmutableDismissSuggestion(int identifier, InputPeer peer, String suggestion) {
        this.identifier = identifier;
        this.peer = peer;
        this.suggestion = suggestion;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public String suggestion() {
        return this.suggestion;
    }

    public final ImmutableDismissSuggestion withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDismissSuggestion(value, this.peer, this.suggestion);
    }

    public final ImmutableDismissSuggestion withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableDismissSuggestion(this.identifier, newValue, this.suggestion);
    }

    public final ImmutableDismissSuggestion withSuggestion(String value) {
        String newValue = Objects.requireNonNull(value, "suggestion");
        if (this.suggestion.equals(newValue)) {
            return this;
        }
        return new ImmutableDismissSuggestion(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDismissSuggestion && this.equalTo(0, (ImmutableDismissSuggestion)another);
    }

    private boolean equalTo(int synthetic, ImmutableDismissSuggestion another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.suggestion.equals(another.suggestion);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.suggestion.hashCode();
        return h;
    }

    public String toString() {
        return "DismissSuggestion{identifier=" + this.identifier + ", peer=" + this.peer + ", suggestion=" + this.suggestion + "}";
    }

    public static ImmutableDismissSuggestion of(InputPeer peer, String suggestion) {
        return new ImmutableDismissSuggestion(peer, suggestion);
    }

    public static ImmutableDismissSuggestion copyOf(DismissSuggestion instance) {
        if (instance instanceof ImmutableDismissSuggestion) {
            return (ImmutableDismissSuggestion)instance;
        }
        return ImmutableDismissSuggestion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_SUGGESTION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private String suggestion;

        private Builder() {
        }

        public final Builder from(DismissSuggestion instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DismissSuggestion instance;
            long bits = 0L;
            if (object instanceof DismissSuggestion) {
                instance = (DismissSuggestion)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.suggestion(instance.suggestion());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder suggestion(String suggestion) {
            this.suggestion = Objects.requireNonNull(suggestion, "suggestion");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDismissSuggestion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDismissSuggestion(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("suggestion");
            }
            return "Cannot build DismissSuggestion, some of required attributes are not set " + attributes;
        }
    }
}

