/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.help.EditUserInfo;

public final class ImmutableEditUserInfo
implements EditUserInfo {
    private final int identifier;
    private final InputUser userId;
    private final String message;
    private final List<MessageEntity> entities;

    private ImmutableEditUserInfo(InputUser userId, String message) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.message = Objects.requireNonNull(message, "message");
        this.entities = Collections.emptyList();
        this.identifier = EditUserInfo.super.identifier();
    }

    private ImmutableEditUserInfo(Builder builder) {
        this.userId = builder.userId;
        this.message = builder.message;
        this.entities = ImmutableEditUserInfo.createUnmodifiableList(true, builder.entities);
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditUserInfo.super.identifier();
    }

    private ImmutableEditUserInfo(int identifier, InputUser userId, String message, List<MessageEntity> entities) {
        this.identifier = identifier;
        this.userId = userId;
        this.message = message;
        this.entities = entities;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public List<MessageEntity> entities() {
        return this.entities;
    }

    public final ImmutableEditUserInfo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditUserInfo(value, this.userId, this.message, this.entities);
    }

    public final ImmutableEditUserInfo withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableEditUserInfo(this.identifier, newValue, this.message, this.entities);
    }

    public final ImmutableEditUserInfo withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableEditUserInfo(this.identifier, this.userId, newValue, this.entities);
    }

    public final ImmutableEditUserInfo withEntities(MessageEntity ... elements) {
        List<MessageEntity> newValue = ImmutableEditUserInfo.createUnmodifiableList(false, ImmutableEditUserInfo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEditUserInfo(this.identifier, this.userId, this.message, newValue);
    }

    public final ImmutableEditUserInfo withEntities(Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = ImmutableEditUserInfo.createUnmodifiableList(false, ImmutableEditUserInfo.createSafeList(elements, true, false));
        return new ImmutableEditUserInfo(this.identifier, this.userId, this.message, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditUserInfo && this.equalTo(0, (ImmutableEditUserInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditUserInfo another) {
        return this.identifier == another.identifier && this.userId.equals(another.userId) && this.message.equals(another.message) && this.entities.equals(another.entities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.entities.hashCode();
        return h;
    }

    public String toString() {
        return "EditUserInfo{identifier=" + this.identifier + ", userId=" + this.userId + ", message=" + this.message + ", entities=" + this.entities + "}";
    }

    public static ImmutableEditUserInfo of(InputUser userId, String message) {
        return new ImmutableEditUserInfo(userId, message);
    }

    public static ImmutableEditUserInfo copyOf(EditUserInfo instance) {
        if (instance instanceof ImmutableEditUserInfo) {
            return (ImmutableEditUserInfo)instance;
        }
        return ImmutableEditUserInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputUser userId;
        private String message;
        private List<MessageEntity> entities = new ArrayList<MessageEntity>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EditUserInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EditUserInfo) {
                instance = (EditUserInfo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.message(instance.message());
                this.addAllEntities(instance.entities());
                this.userId(instance.userId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(Iterable<? extends MessageEntity> elements) {
            this.entities.clear();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public ImmutableEditUserInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditUserInfo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build EditUserInfo, some of required attributes are not set " + attributes;
        }
    }
}

