/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.help.GetAppChangelog;

public final class ImmutableGetAppChangelog
implements GetAppChangelog {
    private final int identifier;
    private final String prevAppVersion;

    private ImmutableGetAppChangelog(String prevAppVersion) {
        this.prevAppVersion = Objects.requireNonNull(prevAppVersion, "prevAppVersion");
        this.identifier = GetAppChangelog.super.identifier();
    }

    private ImmutableGetAppChangelog(Builder builder) {
        this.prevAppVersion = builder.prevAppVersion;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetAppChangelog.super.identifier();
    }

    private ImmutableGetAppChangelog(int identifier, String prevAppVersion) {
        this.identifier = identifier;
        this.prevAppVersion = prevAppVersion;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String prevAppVersion() {
        return this.prevAppVersion;
    }

    public final ImmutableGetAppChangelog withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetAppChangelog(value, this.prevAppVersion);
    }

    public final ImmutableGetAppChangelog withPrevAppVersion(String value) {
        String newValue = Objects.requireNonNull(value, "prevAppVersion");
        if (this.prevAppVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableGetAppChangelog(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetAppChangelog && this.equalTo(0, (ImmutableGetAppChangelog)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetAppChangelog another) {
        return this.identifier == another.identifier && this.prevAppVersion.equals(another.prevAppVersion);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.prevAppVersion.hashCode();
        return h;
    }

    public String toString() {
        return "GetAppChangelog{identifier=" + this.identifier + ", prevAppVersion=" + this.prevAppVersion + "}";
    }

    public static ImmutableGetAppChangelog of(String prevAppVersion) {
        return new ImmutableGetAppChangelog(prevAppVersion);
    }

    public static ImmutableGetAppChangelog copyOf(GetAppChangelog instance) {
        if (instance instanceof ImmutableGetAppChangelog) {
            return (ImmutableGetAppChangelog)instance;
        }
        return ImmutableGetAppChangelog.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PREV_APP_VERSION = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String prevAppVersion;

        private Builder() {
        }

        public final Builder from(GetAppChangelog instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetAppChangelog instance;
            long bits = 0L;
            if (object instanceof GetAppChangelog) {
                instance = (GetAppChangelog)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.prevAppVersion(instance.prevAppVersion());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder prevAppVersion(String prevAppVersion) {
            this.prevAppVersion = Objects.requireNonNull(prevAppVersion, "prevAppVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetAppChangelog build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetAppChangelog(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("prevAppVersion");
            }
            return "Cannot build GetAppChangelog, some of required attributes are not set " + attributes;
        }
    }
}

