/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.help.GetAppUpdate;

public final class ImmutableGetAppUpdate
implements GetAppUpdate {
    private final int identifier;
    private final String source;

    private ImmutableGetAppUpdate(String source) {
        this.source = Objects.requireNonNull(source, "source");
        this.identifier = GetAppUpdate.super.identifier();
    }

    private ImmutableGetAppUpdate(Builder builder) {
        this.source = builder.source;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetAppUpdate.super.identifier();
    }

    private ImmutableGetAppUpdate(int identifier, String source) {
        this.identifier = identifier;
        this.source = source;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String source() {
        return this.source;
    }

    public final ImmutableGetAppUpdate withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetAppUpdate(value, this.source);
    }

    public final ImmutableGetAppUpdate withSource(String value) {
        String newValue = Objects.requireNonNull(value, "source");
        if (this.source.equals(newValue)) {
            return this;
        }
        return new ImmutableGetAppUpdate(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetAppUpdate && this.equalTo(0, (ImmutableGetAppUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetAppUpdate another) {
        return this.identifier == another.identifier && this.source.equals(another.source);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.source.hashCode();
        return h;
    }

    public String toString() {
        return "GetAppUpdate{identifier=" + this.identifier + ", source=" + this.source + "}";
    }

    public static ImmutableGetAppUpdate of(String source) {
        return new ImmutableGetAppUpdate(source);
    }

    public static ImmutableGetAppUpdate copyOf(GetAppUpdate instance) {
        if (instance instanceof ImmutableGetAppUpdate) {
            return (ImmutableGetAppUpdate)instance;
        }
        return ImmutableGetAppUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SOURCE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String source;

        private Builder() {
        }

        public final Builder from(GetAppUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetAppUpdate instance;
            long bits = 0L;
            if (object instanceof GetAppUpdate) {
                instance = (GetAppUpdate)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.source(instance.source());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder source(String source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetAppUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetAppUpdate(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("source");
            }
            return "Cannot build GetAppUpdate, some of required attributes are not set " + attributes;
        }
    }
}

