/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.help;

import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.help.GetConfig;

public final class ImmutableGetConfig
implements GetConfig {
    private final int identifier;
    private static final ImmutableGetConfig INSTANCE = ImmutableGetConfig.validate(new ImmutableGetConfig());

    private ImmutableGetConfig() {
        this.identifier = GetConfig.super.identifier();
    }

    private ImmutableGetConfig(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetConfig.super.identifier();
    }

    private ImmutableGetConfig(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableGetConfig withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableGetConfig.validate(new ImmutableGetConfig(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetConfig && this.equalTo(0, (ImmutableGetConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetConfig another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "GetConfig{identifier=" + this.identifier + "}";
    }

    public static ImmutableGetConfig of() {
        return INSTANCE;
    }

    private static ImmutableGetConfig validate(ImmutableGetConfig instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableGetConfig copyOf(GetConfig instance) {
        if (instance instanceof ImmutableGetConfig) {
            return (ImmutableGetConfig)instance;
        }
        return ImmutableGetConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetConfig) {
                instance = (GetConfig)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableGetConfig build() {
            return ImmutableGetConfig.validate(new ImmutableGetConfig(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

