/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.help.GetCountriesList;

public final class ImmutableGetCountriesList
implements GetCountriesList {
    private final int identifier;
    private final String langCode;
    private final int hash;

    private ImmutableGetCountriesList(String langCode, int hash) {
        this.langCode = Objects.requireNonNull(langCode, "langCode");
        this.hash = hash;
        this.identifier = GetCountriesList.super.identifier();
    }

    private ImmutableGetCountriesList(Builder builder) {
        this.langCode = builder.langCode;
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetCountriesList.super.identifier();
    }

    private ImmutableGetCountriesList(int identifier, String langCode, int hash) {
        this.identifier = identifier;
        this.langCode = langCode;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String langCode() {
        return this.langCode;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    public final ImmutableGetCountriesList withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetCountriesList(value, this.langCode, this.hash);
    }

    public final ImmutableGetCountriesList withLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "langCode");
        if (this.langCode.equals(newValue)) {
            return this;
        }
        return new ImmutableGetCountriesList(this.identifier, newValue, this.hash);
    }

    public final ImmutableGetCountriesList withHash(int value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetCountriesList(this.identifier, this.langCode, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetCountriesList && this.equalTo(0, (ImmutableGetCountriesList)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetCountriesList another) {
        return this.identifier == another.identifier && this.langCode.equals(another.langCode) && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.langCode.hashCode();
        h += (h << 5) + this.hash;
        return h;
    }

    public String toString() {
        return "GetCountriesList{identifier=" + this.identifier + ", langCode=" + this.langCode + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetCountriesList of(String langCode, int hash) {
        return new ImmutableGetCountriesList(langCode, hash);
    }

    public static ImmutableGetCountriesList copyOf(GetCountriesList instance) {
        if (instance instanceof ImmutableGetCountriesList) {
            return (ImmutableGetCountriesList)instance;
        }
        return ImmutableGetCountriesList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LANG_CODE = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String langCode;
        private int hash;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetCountriesList instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetCountriesList) {
                instance = (GetCountriesList)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
                this.langCode(instance.langCode());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder langCode(String langCode) {
            this.langCode = Objects.requireNonNull(langCode, "langCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder hash(int hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetCountriesList build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetCountriesList(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("langCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetCountriesList, some of required attributes are not set " + attributes;
        }
    }
}

