/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.help.GetDeepLinkInfo;

public final class ImmutableGetDeepLinkInfo
implements GetDeepLinkInfo {
    private final int identifier;
    private final String path;

    private ImmutableGetDeepLinkInfo(String path) {
        this.path = Objects.requireNonNull(path, "path");
        this.identifier = GetDeepLinkInfo.super.identifier();
    }

    private ImmutableGetDeepLinkInfo(Builder builder) {
        this.path = builder.path;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetDeepLinkInfo.super.identifier();
    }

    private ImmutableGetDeepLinkInfo(int identifier, String path) {
        this.identifier = identifier;
        this.path = path;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String path() {
        return this.path;
    }

    public final ImmutableGetDeepLinkInfo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetDeepLinkInfo(value, this.path);
    }

    public final ImmutableGetDeepLinkInfo withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableGetDeepLinkInfo(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetDeepLinkInfo && this.equalTo(0, (ImmutableGetDeepLinkInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetDeepLinkInfo another) {
        return this.identifier == another.identifier && this.path.equals(another.path);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.path.hashCode();
        return h;
    }

    public String toString() {
        return "GetDeepLinkInfo{identifier=" + this.identifier + ", path=" + this.path + "}";
    }

    public static ImmutableGetDeepLinkInfo of(String path) {
        return new ImmutableGetDeepLinkInfo(path);
    }

    public static ImmutableGetDeepLinkInfo copyOf(GetDeepLinkInfo instance) {
        if (instance instanceof ImmutableGetDeepLinkInfo) {
            return (ImmutableGetDeepLinkInfo)instance;
        }
        return ImmutableGetDeepLinkInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String path;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetDeepLinkInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetDeepLinkInfo) {
                instance = (GetDeepLinkInfo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.path(instance.path());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetDeepLinkInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetDeepLinkInfo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            return "Cannot build GetDeepLinkInfo, some of required attributes are not set " + attributes;
        }
    }
}

