/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.help;

import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.help.GetSupport;

public final class ImmutableGetSupport
implements GetSupport {
    private final int identifier;
    private static final ImmutableGetSupport INSTANCE = ImmutableGetSupport.validate(new ImmutableGetSupport());

    private ImmutableGetSupport() {
        this.identifier = GetSupport.super.identifier();
    }

    private ImmutableGetSupport(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetSupport.super.identifier();
    }

    private ImmutableGetSupport(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableGetSupport withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableGetSupport.validate(new ImmutableGetSupport(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetSupport && this.equalTo(0, (ImmutableGetSupport)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetSupport another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "GetSupport{identifier=" + this.identifier + "}";
    }

    public static ImmutableGetSupport of() {
        return INSTANCE;
    }

    private static ImmutableGetSupport validate(ImmutableGetSupport instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableGetSupport copyOf(GetSupport instance) {
        if (instance instanceof ImmutableGetSupport) {
            return (ImmutableGetSupport)instance;
        }
        return ImmutableGetSupport.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetSupport instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetSupport) {
                instance = (GetSupport)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableGetSupport build() {
            return ImmutableGetSupport.validate(new ImmutableGetSupport(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

