/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.help.HidePromoData;

public final class ImmutableHidePromoData
implements HidePromoData {
    private final int identifier;
    private final InputPeer peer;

    private ImmutableHidePromoData(InputPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = HidePromoData.super.identifier();
    }

    private ImmutableHidePromoData(Builder builder) {
        this.peer = builder.peer;
        this.identifier = builder.identifierIsSet() ? builder.identifier : HidePromoData.super.identifier();
    }

    private ImmutableHidePromoData(int identifier, InputPeer peer) {
        this.identifier = identifier;
        this.peer = peer;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    public final ImmutableHidePromoData withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableHidePromoData(value, this.peer);
    }

    public final ImmutableHidePromoData withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableHidePromoData(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHidePromoData && this.equalTo(0, (ImmutableHidePromoData)another);
    }

    private boolean equalTo(int synthetic, ImmutableHidePromoData another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "HidePromoData{identifier=" + this.identifier + ", peer=" + this.peer + "}";
    }

    public static ImmutableHidePromoData of(InputPeer peer) {
        return new ImmutableHidePromoData(peer);
    }

    public static ImmutableHidePromoData copyOf(HidePromoData instance) {
        if (instance instanceof ImmutableHidePromoData) {
            return (ImmutableHidePromoData)instance;
        }
        return ImmutableHidePromoData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPeer peer;

        private Builder() {
        }

        public final Builder from(HidePromoData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HidePromoData instance;
            long bits = 0L;
            if (object instanceof HidePromoData) {
                instance = (HidePromoData)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableHidePromoData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHidePromoData(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build HidePromoData, some of required attributes are not set " + attributes;
        }
    }
}

