/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputAppEvent;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.help.SaveAppLog;

public final class ImmutableSaveAppLog
implements SaveAppLog {
    private final int identifier;
    private final List<InputAppEvent> events;

    private ImmutableSaveAppLog(Builder builder) {
        this.events = ImmutableSaveAppLog.createUnmodifiableList(true, builder.events);
        this.identifier = builder.identifierIsSet() ? builder.identifier : SaveAppLog.super.identifier();
    }

    private ImmutableSaveAppLog(int identifier, List<InputAppEvent> events) {
        this.identifier = identifier;
        this.events = events;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<InputAppEvent> events() {
        return this.events;
    }

    public final ImmutableSaveAppLog withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveAppLog(value, this.events);
    }

    public final ImmutableSaveAppLog withEvents(InputAppEvent ... elements) {
        List<InputAppEvent> newValue = ImmutableSaveAppLog.createUnmodifiableList(false, ImmutableSaveAppLog.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSaveAppLog(this.identifier, newValue);
    }

    public final ImmutableSaveAppLog withEvents(Iterable<? extends InputAppEvent> elements) {
        if (this.events == elements) {
            return this;
        }
        List<InputAppEvent> newValue = ImmutableSaveAppLog.createUnmodifiableList(false, ImmutableSaveAppLog.createSafeList(elements, true, false));
        return new ImmutableSaveAppLog(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveAppLog && this.equalTo(0, (ImmutableSaveAppLog)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveAppLog another) {
        return this.identifier == another.identifier && this.events.equals(another.events);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.events.hashCode();
        return h;
    }

    public String toString() {
        return "SaveAppLog{identifier=" + this.identifier + ", events=" + this.events + "}";
    }

    public static ImmutableSaveAppLog copyOf(SaveAppLog instance) {
        if (instance instanceof ImmutableSaveAppLog) {
            return (ImmutableSaveAppLog)instance;
        }
        return ImmutableSaveAppLog.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<InputAppEvent> events = new ArrayList<InputAppEvent>();

        private Builder() {
        }

        public final Builder from(SaveAppLog instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SaveAppLog instance;
            long bits = 0L;
            if (object instanceof SaveAppLog) {
                instance = (SaveAppLog)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllEvents(instance.events());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addEvent(InputAppEvent element) {
            this.events.add(Objects.requireNonNull(element, "events element"));
            return this;
        }

        public final Builder addEvents(InputAppEvent ... elements) {
            for (InputAppEvent element : elements) {
                this.events.add(Objects.requireNonNull(element, "events element"));
            }
            return this;
        }

        public final Builder events(Iterable<? extends InputAppEvent> elements) {
            this.events.clear();
            return this.addAllEvents(elements);
        }

        public final Builder addAllEvents(Iterable<? extends InputAppEvent> elements) {
            for (InputAppEvent inputAppEvent : elements) {
                this.events.add(Objects.requireNonNull(inputAppEvent, "events element"));
            }
            return this;
        }

        public ImmutableSaveAppLog build() {
            return new ImmutableSaveAppLog(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

