/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.help;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.help.SetBotUpdatesStatus;

public final class ImmutableSetBotUpdatesStatus
implements SetBotUpdatesStatus {
    private final int identifier;
    private final int pendingUpdatesCount;
    private final String message;

    private ImmutableSetBotUpdatesStatus(int pendingUpdatesCount, String message) {
        this.pendingUpdatesCount = pendingUpdatesCount;
        this.message = Objects.requireNonNull(message, "message");
        this.identifier = SetBotUpdatesStatus.super.identifier();
    }

    private ImmutableSetBotUpdatesStatus(Builder builder) {
        this.pendingUpdatesCount = builder.pendingUpdatesCount;
        this.message = builder.message;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetBotUpdatesStatus.super.identifier();
    }

    private ImmutableSetBotUpdatesStatus(int identifier, int pendingUpdatesCount, String message) {
        this.identifier = identifier;
        this.pendingUpdatesCount = pendingUpdatesCount;
        this.message = message;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int pendingUpdatesCount() {
        return this.pendingUpdatesCount;
    }

    @Override
    public String message() {
        return this.message;
    }

    public final ImmutableSetBotUpdatesStatus withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetBotUpdatesStatus(value, this.pendingUpdatesCount, this.message);
    }

    public final ImmutableSetBotUpdatesStatus withPendingUpdatesCount(int value) {
        if (this.pendingUpdatesCount == value) {
            return this;
        }
        return new ImmutableSetBotUpdatesStatus(this.identifier, value, this.message);
    }

    public final ImmutableSetBotUpdatesStatus withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableSetBotUpdatesStatus(this.identifier, this.pendingUpdatesCount, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetBotUpdatesStatus && this.equalTo(0, (ImmutableSetBotUpdatesStatus)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetBotUpdatesStatus another) {
        return this.identifier == another.identifier && this.pendingUpdatesCount == another.pendingUpdatesCount && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.pendingUpdatesCount;
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return "SetBotUpdatesStatus{identifier=" + this.identifier + ", pendingUpdatesCount=" + this.pendingUpdatesCount + ", message=" + this.message + "}";
    }

    public static ImmutableSetBotUpdatesStatus of(int pendingUpdatesCount, String message) {
        return new ImmutableSetBotUpdatesStatus(pendingUpdatesCount, message);
    }

    public static ImmutableSetBotUpdatesStatus copyOf(SetBotUpdatesStatus instance) {
        if (instance instanceof ImmutableSetBotUpdatesStatus) {
            return (ImmutableSetBotUpdatesStatus)instance;
        }
        return ImmutableSetBotUpdatesStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PENDING_UPDATES_COUNT = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int pendingUpdatesCount;
        private String message;

        private Builder() {
        }

        public final Builder from(SetBotUpdatesStatus instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetBotUpdatesStatus instance;
            long bits = 0L;
            if (object instanceof SetBotUpdatesStatus) {
                instance = (SetBotUpdatesStatus)object;
                this.message(instance.message());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.pendingUpdatesCount(instance.pendingUpdatesCount());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder pendingUpdatesCount(int pendingUpdatesCount) {
            this.pendingUpdatesCount = pendingUpdatesCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSetBotUpdatesStatus build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetBotUpdatesStatus(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pendingUpdatesCount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build SetBotUpdatesStatus, some of required attributes are not set " + attributes;
        }
    }
}

