/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.langpack;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.langpack.GetDifference;

public final class ImmutableGetDifference
implements GetDifference {
    private final int identifier;
    private final String langPack;
    private final String langCode;
    private final int fromVersion;

    private ImmutableGetDifference(String langPack, String langCode, int fromVersion) {
        this.langPack = Objects.requireNonNull(langPack, "langPack");
        this.langCode = Objects.requireNonNull(langCode, "langCode");
        this.fromVersion = fromVersion;
        this.identifier = GetDifference.super.identifier();
    }

    private ImmutableGetDifference(Builder builder) {
        this.langPack = builder.langPack;
        this.langCode = builder.langCode;
        this.fromVersion = builder.fromVersion;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetDifference.super.identifier();
    }

    private ImmutableGetDifference(int identifier, String langPack, String langCode, int fromVersion) {
        this.identifier = identifier;
        this.langPack = langPack;
        this.langCode = langCode;
        this.fromVersion = fromVersion;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String langPack() {
        return this.langPack;
    }

    @Override
    public String langCode() {
        return this.langCode;
    }

    @Override
    public int fromVersion() {
        return this.fromVersion;
    }

    public final ImmutableGetDifference withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetDifference(value, this.langPack, this.langCode, this.fromVersion);
    }

    public final ImmutableGetDifference withLangPack(String value) {
        String newValue = Objects.requireNonNull(value, "langPack");
        if (this.langPack.equals(newValue)) {
            return this;
        }
        return new ImmutableGetDifference(this.identifier, newValue, this.langCode, this.fromVersion);
    }

    public final ImmutableGetDifference withLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "langCode");
        if (this.langCode.equals(newValue)) {
            return this;
        }
        return new ImmutableGetDifference(this.identifier, this.langPack, newValue, this.fromVersion);
    }

    public final ImmutableGetDifference withFromVersion(int value) {
        if (this.fromVersion == value) {
            return this;
        }
        return new ImmutableGetDifference(this.identifier, this.langPack, this.langCode, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetDifference && this.equalTo(0, (ImmutableGetDifference)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetDifference another) {
        return this.identifier == another.identifier && this.langPack.equals(another.langPack) && this.langCode.equals(another.langCode) && this.fromVersion == another.fromVersion;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.langPack.hashCode();
        h += (h << 5) + this.langCode.hashCode();
        h += (h << 5) + this.fromVersion;
        return h;
    }

    public String toString() {
        return "GetDifference{identifier=" + this.identifier + ", langPack=" + this.langPack + ", langCode=" + this.langCode + ", fromVersion=" + this.fromVersion + "}";
    }

    public static ImmutableGetDifference of(String langPack, String langCode, int fromVersion) {
        return new ImmutableGetDifference(langPack, langCode, fromVersion);
    }

    public static ImmutableGetDifference copyOf(GetDifference instance) {
        if (instance instanceof ImmutableGetDifference) {
            return (ImmutableGetDifference)instance;
        }
        return ImmutableGetDifference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LANG_PACK = 1L;
        private static final long INIT_BIT_LANG_CODE = 2L;
        private static final long INIT_BIT_FROM_VERSION = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String langPack;
        private String langCode;
        private int fromVersion;

        private Builder() {
        }

        public final Builder from(GetDifference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetDifference instance;
            long bits = 0L;
            if (object instanceof GetDifference) {
                instance = (GetDifference)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.fromVersion(instance.fromVersion());
                this.langPack(instance.langPack());
                this.langCode(instance.langCode());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder langPack(String langPack) {
            this.langPack = Objects.requireNonNull(langPack, "langPack");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder langCode(String langCode) {
            this.langCode = Objects.requireNonNull(langCode, "langCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder fromVersion(int fromVersion) {
            this.fromVersion = fromVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetDifference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetDifference(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("langPack");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("langCode");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("fromVersion");
            }
            return "Cannot build GetDifference, some of required attributes are not set " + attributes;
        }
    }
}

