/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.langpack;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.langpack.GetLanguage;

public final class ImmutableGetLanguage
implements GetLanguage {
    private final int identifier;
    private final String langPack;
    private final String langCode;

    private ImmutableGetLanguage(String langPack, String langCode) {
        this.langPack = Objects.requireNonNull(langPack, "langPack");
        this.langCode = Objects.requireNonNull(langCode, "langCode");
        this.identifier = GetLanguage.super.identifier();
    }

    private ImmutableGetLanguage(Builder builder) {
        this.langPack = builder.langPack;
        this.langCode = builder.langCode;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetLanguage.super.identifier();
    }

    private ImmutableGetLanguage(int identifier, String langPack, String langCode) {
        this.identifier = identifier;
        this.langPack = langPack;
        this.langCode = langCode;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String langPack() {
        return this.langPack;
    }

    @Override
    public String langCode() {
        return this.langCode;
    }

    public final ImmutableGetLanguage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetLanguage(value, this.langPack, this.langCode);
    }

    public final ImmutableGetLanguage withLangPack(String value) {
        String newValue = Objects.requireNonNull(value, "langPack");
        if (this.langPack.equals(newValue)) {
            return this;
        }
        return new ImmutableGetLanguage(this.identifier, newValue, this.langCode);
    }

    public final ImmutableGetLanguage withLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "langCode");
        if (this.langCode.equals(newValue)) {
            return this;
        }
        return new ImmutableGetLanguage(this.identifier, this.langPack, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetLanguage && this.equalTo(0, (ImmutableGetLanguage)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetLanguage another) {
        return this.identifier == another.identifier && this.langPack.equals(another.langPack) && this.langCode.equals(another.langCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.langPack.hashCode();
        h += (h << 5) + this.langCode.hashCode();
        return h;
    }

    public String toString() {
        return "GetLanguage{identifier=" + this.identifier + ", langPack=" + this.langPack + ", langCode=" + this.langCode + "}";
    }

    public static ImmutableGetLanguage of(String langPack, String langCode) {
        return new ImmutableGetLanguage(langPack, langCode);
    }

    public static ImmutableGetLanguage copyOf(GetLanguage instance) {
        if (instance instanceof ImmutableGetLanguage) {
            return (ImmutableGetLanguage)instance;
        }
        return ImmutableGetLanguage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LANG_PACK = 1L;
        private static final long INIT_BIT_LANG_CODE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String langPack;
        private String langCode;

        private Builder() {
        }

        public final Builder from(GetLanguage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetLanguage instance;
            long bits = 0L;
            if (object instanceof GetLanguage) {
                instance = (GetLanguage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.langPack(instance.langPack());
                this.langCode(instance.langCode());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder langPack(String langPack) {
            this.langPack = Objects.requireNonNull(langPack, "langPack");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder langCode(String langCode) {
            this.langCode = Objects.requireNonNull(langCode, "langCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetLanguage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetLanguage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("langPack");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("langCode");
            }
            return "Cannot build GetLanguage, some of required attributes are not set " + attributes;
        }
    }
}

