/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.langpack;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.langpack.GetLanguages;

public final class ImmutableGetLanguages
implements GetLanguages {
    private final int identifier;
    private final String langPack;

    private ImmutableGetLanguages(String langPack) {
        this.langPack = Objects.requireNonNull(langPack, "langPack");
        this.identifier = GetLanguages.super.identifier();
    }

    private ImmutableGetLanguages(Builder builder) {
        this.langPack = builder.langPack;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetLanguages.super.identifier();
    }

    private ImmutableGetLanguages(int identifier, String langPack) {
        this.identifier = identifier;
        this.langPack = langPack;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String langPack() {
        return this.langPack;
    }

    public final ImmutableGetLanguages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetLanguages(value, this.langPack);
    }

    public final ImmutableGetLanguages withLangPack(String value) {
        String newValue = Objects.requireNonNull(value, "langPack");
        if (this.langPack.equals(newValue)) {
            return this;
        }
        return new ImmutableGetLanguages(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetLanguages && this.equalTo(0, (ImmutableGetLanguages)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetLanguages another) {
        return this.identifier == another.identifier && this.langPack.equals(another.langPack);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.langPack.hashCode();
        return h;
    }

    public String toString() {
        return "GetLanguages{identifier=" + this.identifier + ", langPack=" + this.langPack + "}";
    }

    public static ImmutableGetLanguages of(String langPack) {
        return new ImmutableGetLanguages(langPack);
    }

    public static ImmutableGetLanguages copyOf(GetLanguages instance) {
        if (instance instanceof ImmutableGetLanguages) {
            return (ImmutableGetLanguages)instance;
        }
        return ImmutableGetLanguages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LANG_PACK = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String langPack;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetLanguages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetLanguages) {
                instance = (GetLanguages)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.langPack(instance.langPack());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder langPack(String langPack) {
            this.langPack = Objects.requireNonNull(langPack, "langPack");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetLanguages build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetLanguages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("langPack");
            }
            return "Cannot build GetLanguages, some of required attributes are not set " + attributes;
        }
    }
}

