/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.langpack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.langpack.GetStrings;

public final class ImmutableGetStrings
implements GetStrings {
    private final int identifier;
    private final String langPack;
    private final String langCode;
    private final List<String> keys;

    private ImmutableGetStrings(String langPack, String langCode) {
        this.langPack = Objects.requireNonNull(langPack, "langPack");
        this.langCode = Objects.requireNonNull(langCode, "langCode");
        this.keys = Collections.emptyList();
        this.identifier = GetStrings.super.identifier();
    }

    private ImmutableGetStrings(Builder builder) {
        this.langPack = builder.langPack;
        this.langCode = builder.langCode;
        this.keys = ImmutableGetStrings.createUnmodifiableList(true, builder.keys);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetStrings.super.identifier();
    }

    private ImmutableGetStrings(int identifier, String langPack, String langCode, List<String> keys) {
        this.identifier = identifier;
        this.langPack = langPack;
        this.langCode = langCode;
        this.keys = keys;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String langPack() {
        return this.langPack;
    }

    @Override
    public String langCode() {
        return this.langCode;
    }

    @Override
    public List<String> keys() {
        return this.keys;
    }

    public final ImmutableGetStrings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetStrings(value, this.langPack, this.langCode, this.keys);
    }

    public final ImmutableGetStrings withLangPack(String value) {
        String newValue = Objects.requireNonNull(value, "langPack");
        if (this.langPack.equals(newValue)) {
            return this;
        }
        return new ImmutableGetStrings(this.identifier, newValue, this.langCode, this.keys);
    }

    public final ImmutableGetStrings withLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "langCode");
        if (this.langCode.equals(newValue)) {
            return this;
        }
        return new ImmutableGetStrings(this.identifier, this.langPack, newValue, this.keys);
    }

    public final ImmutableGetStrings withKeys(String ... elements) {
        List<String> newValue = ImmutableGetStrings.createUnmodifiableList(false, ImmutableGetStrings.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetStrings(this.identifier, this.langPack, this.langCode, newValue);
    }

    public final ImmutableGetStrings withKeys(Iterable<String> elements) {
        if (this.keys == elements) {
            return this;
        }
        List<String> newValue = ImmutableGetStrings.createUnmodifiableList(false, ImmutableGetStrings.createSafeList(elements, true, false));
        return new ImmutableGetStrings(this.identifier, this.langPack, this.langCode, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetStrings && this.equalTo(0, (ImmutableGetStrings)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetStrings another) {
        return this.identifier == another.identifier && this.langPack.equals(another.langPack) && this.langCode.equals(another.langCode) && this.keys.equals(another.keys);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.langPack.hashCode();
        h += (h << 5) + this.langCode.hashCode();
        h += (h << 5) + this.keys.hashCode();
        return h;
    }

    public String toString() {
        return "GetStrings{identifier=" + this.identifier + ", langPack=" + this.langPack + ", langCode=" + this.langCode + ", keys=" + this.keys + "}";
    }

    public static ImmutableGetStrings of(String langPack, String langCode) {
        return new ImmutableGetStrings(langPack, langCode);
    }

    public static ImmutableGetStrings copyOf(GetStrings instance) {
        if (instance instanceof ImmutableGetStrings) {
            return (ImmutableGetStrings)instance;
        }
        return ImmutableGetStrings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_LANG_PACK = 1L;
        private static final long INIT_BIT_LANG_CODE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String langPack;
        private String langCode;
        private List<String> keys = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetStrings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetStrings) {
                instance = (GetStrings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.langPack(instance.langPack());
                this.addAllKeys(instance.keys());
                this.langCode(instance.langCode());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder langPack(String langPack) {
            this.langPack = Objects.requireNonNull(langPack, "langPack");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder langCode(String langCode) {
            this.langCode = Objects.requireNonNull(langCode, "langCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addKey(String element) {
            this.keys.add(Objects.requireNonNull(element, "keys element"));
            return this;
        }

        public final Builder addKeys(String ... elements) {
            for (String element : elements) {
                this.keys.add(Objects.requireNonNull(element, "keys element"));
            }
            return this;
        }

        public final Builder keys(Iterable<String> elements) {
            this.keys.clear();
            return this.addAllKeys(elements);
        }

        public final Builder addAllKeys(Iterable<String> elements) {
            for (String element : elements) {
                this.keys.add(Objects.requireNonNull(element, "keys element"));
            }
            return this;
        }

        public ImmutableGetStrings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetStrings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("langPack");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("langCode");
            }
            return "Cannot build GetStrings, some of required attributes are not set " + attributes;
        }
    }
}

