/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputEncryptedChat;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.AcceptEncryption;

public final class ImmutableAcceptEncryption
implements AcceptEncryption {
    private final int identifier;
    private final InputEncryptedChat peer;
    private final ByteBuf gB;
    private final long keyFingerprint;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAcceptEncryption(InputEncryptedChat peer, long keyFingerprint) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.keyFingerprint = keyFingerprint;
        this.gB = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableAcceptEncryption(Builder builder) {
        this.peer = builder.peer;
        this.gB = builder.gB_build();
        this.keyFingerprint = builder.keyFingerprint;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableAcceptEncryption(int identifier, InputEncryptedChat peer, ByteBuf gB, long keyFingerprint) {
        this.identifier = identifier;
        this.peer = peer;
        this.gB = gB;
        this.keyFingerprint = keyFingerprint;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return AcceptEncryption.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public InputEncryptedChat peer() {
        return this.peer;
    }

    @Override
    public ByteBuf gB() {
        return this.gB.duplicate();
    }

    @Override
    public long keyFingerprint() {
        return this.keyFingerprint;
    }

    public final ImmutableAcceptEncryption withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAcceptEncryption(value, this.peer, this.gB, this.keyFingerprint);
    }

    public final ImmutableAcceptEncryption withPeer(InputEncryptedChat value) {
        if (this.peer == value) {
            return this;
        }
        InputEncryptedChat newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableAcceptEncryption(this.identifier, newValue, this.gB, this.keyFingerprint);
    }

    public ImmutableAcceptEncryption withGB(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.gB == newValue) {
            return this;
        }
        return new ImmutableAcceptEncryption(this.identifier, this.peer, newValue, this.keyFingerprint);
    }

    public final ImmutableAcceptEncryption withKeyFingerprint(long value) {
        if (this.keyFingerprint == value) {
            return this;
        }
        return new ImmutableAcceptEncryption(this.identifier, this.peer, this.gB, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAcceptEncryption && this.equalTo(0, (ImmutableAcceptEncryption)another);
    }

    private boolean equalTo(int synthetic, ImmutableAcceptEncryption another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.gB().equals((Object)another.gB()) && this.keyFingerprint == another.keyFingerprint;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.gB().hashCode();
        h += (h << 5) + Long.hashCode(this.keyFingerprint);
        return h;
    }

    public String toString() {
        return "AcceptEncryption{identifier=" + this.identifier + ", peer=" + this.peer + ", gB=" + ByteBufUtil.hexDump((ByteBuf)this.gB) + ", keyFingerprint=" + this.keyFingerprint + "}";
    }

    public static ImmutableAcceptEncryption of(InputEncryptedChat peer, long keyFingerprint) {
        return new ImmutableAcceptEncryption(peer, keyFingerprint);
    }

    public static ImmutableAcceptEncryption copyOf(AcceptEncryption instance) {
        if (instance instanceof ImmutableAcceptEncryption) {
            return (ImmutableAcceptEncryption)instance;
        }
        return ImmutableAcceptEncryption.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_KEY_FINGERPRINT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf gB_value = null;
        private int identifier;
        private InputEncryptedChat peer;
        private long keyFingerprint;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AcceptEncryption instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof AcceptEncryption) {
                instance = (AcceptEncryption)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.gB(instance.gB());
                this.peer(instance.peer());
                this.keyFingerprint(instance.keyFingerprint());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputEncryptedChat peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder gB(ByteBuf value) {
            this.gB_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder keyFingerprint(long keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAcceptEncryption build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAcceptEncryption(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("keyFingerprint");
            }
            return "Cannot build AcceptEncryption, some of required attributes are not set " + attributes;
        }

        private ByteBuf gB_build() {
            return Objects.requireNonNull(this.gB_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableAcceptEncryption.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build AcceptEncryption, attribute initializers form cycle " + attributes;
        }
    }
}

