/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.AcceptUrlAuth;

public final class ImmutableAcceptUrlAuth
implements AcceptUrlAuth {
    private final int identifier;
    private final int flags;
    private final boolean writeAllowed;
    @Nullable
    private final InputPeer peer;
    @Nullable
    private final Integer msgId;
    @Nullable
    private final Integer buttonId;
    @Nullable
    private final String url;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableAcceptUrlAuth INSTANCE = ImmutableAcceptUrlAuth.validate(new ImmutableAcceptUrlAuth());

    private ImmutableAcceptUrlAuth() {
        this.peer = null;
        this.msgId = null;
        this.buttonId = null;
        this.url = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.writeAllowed = this.initShim.writeAllowed();
        this.initShim = null;
    }

    private ImmutableAcceptUrlAuth(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.buttonId = builder.buttonId;
        this.url = builder.url;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.writeAllowedIsSet()) {
            this.initShim.writeAllowed(builder.writeAllowed);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.writeAllowed = this.initShim.writeAllowed();
        this.initShim = null;
    }

    private ImmutableAcceptUrlAuth(int identifier, int flags, boolean writeAllowed, @Nullable InputPeer peer, @Nullable Integer msgId, @Nullable Integer buttonId, @Nullable String url) {
        this.identifier = identifier;
        this.flags = flags;
        this.writeAllowed = writeAllowed;
        this.peer = peer;
        this.msgId = msgId;
        this.buttonId = buttonId;
        this.url = url;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return AcceptUrlAuth.super.identifier();
    }

    private int flagsInitialize() {
        return AcceptUrlAuth.super.flags();
    }

    private boolean writeAllowedInitialize() {
        return AcceptUrlAuth.super.writeAllowed();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean writeAllowed() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeAllowed() : this.writeAllowed;
    }

    @Override
    @Nullable
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    @Nullable
    public Integer msgId() {
        return this.msgId;
    }

    @Override
    @Nullable
    public Integer buttonId() {
        return this.buttonId;
    }

    @Override
    @Nullable
    public String url() {
        return this.url;
    }

    public final ImmutableAcceptUrlAuth withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableAcceptUrlAuth.validate(new ImmutableAcceptUrlAuth(value, this.flags, this.writeAllowed, this.peer, this.msgId, this.buttonId, this.url));
    }

    public final ImmutableAcceptUrlAuth withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableAcceptUrlAuth.validate(new ImmutableAcceptUrlAuth(this.identifier, value, this.writeAllowed, this.peer, this.msgId, this.buttonId, this.url));
    }

    public final ImmutableAcceptUrlAuth withWriteAllowed(boolean value) {
        if (this.writeAllowed == value) {
            return this;
        }
        return ImmutableAcceptUrlAuth.validate(new ImmutableAcceptUrlAuth(this.identifier, this.flags, value, this.peer, this.msgId, this.buttonId, this.url));
    }

    public final ImmutableAcceptUrlAuth withPeer(@Nullable InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        return ImmutableAcceptUrlAuth.validate(new ImmutableAcceptUrlAuth(this.identifier, this.flags, this.writeAllowed, value, this.msgId, this.buttonId, this.url));
    }

    public final ImmutableAcceptUrlAuth withMsgId(@Nullable Integer value) {
        if (Objects.equals(this.msgId, value)) {
            return this;
        }
        return ImmutableAcceptUrlAuth.validate(new ImmutableAcceptUrlAuth(this.identifier, this.flags, this.writeAllowed, this.peer, value, this.buttonId, this.url));
    }

    public final ImmutableAcceptUrlAuth withButtonId(@Nullable Integer value) {
        if (Objects.equals(this.buttonId, value)) {
            return this;
        }
        return ImmutableAcceptUrlAuth.validate(new ImmutableAcceptUrlAuth(this.identifier, this.flags, this.writeAllowed, this.peer, this.msgId, value, this.url));
    }

    public final ImmutableAcceptUrlAuth withUrl(@Nullable String value) {
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return ImmutableAcceptUrlAuth.validate(new ImmutableAcceptUrlAuth(this.identifier, this.flags, this.writeAllowed, this.peer, this.msgId, this.buttonId, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAcceptUrlAuth && this.equalTo(0, (ImmutableAcceptUrlAuth)another);
    }

    private boolean equalTo(int synthetic, ImmutableAcceptUrlAuth another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.writeAllowed == another.writeAllowed && Objects.equals(this.peer, another.peer) && Objects.equals(this.msgId, another.msgId) && Objects.equals(this.buttonId, another.buttonId) && Objects.equals(this.url, another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.writeAllowed);
        h += (h << 5) + Objects.hashCode(this.peer);
        h += (h << 5) + Objects.hashCode(this.msgId);
        h += (h << 5) + Objects.hashCode(this.buttonId);
        h += (h << 5) + Objects.hashCode(this.url);
        return h;
    }

    public String toString() {
        return "AcceptUrlAuth{identifier=" + this.identifier + ", flags=" + this.flags + ", writeAllowed=" + this.writeAllowed + ", peer=" + this.peer + ", msgId=" + this.msgId + ", buttonId=" + this.buttonId + ", url=" + this.url + "}";
    }

    public static ImmutableAcceptUrlAuth of() {
        return INSTANCE;
    }

    private static ImmutableAcceptUrlAuth validate(ImmutableAcceptUrlAuth instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableAcceptUrlAuth copyOf(AcceptUrlAuth instance) {
        if (instance instanceof ImmutableAcceptUrlAuth) {
            return (ImmutableAcceptUrlAuth)instance;
        }
        return ImmutableAcceptUrlAuth.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_WRITE_ALLOWED = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean writeAllowed;
        private InputPeer peer;
        private Integer msgId;
        private Integer buttonId;
        private String url;

        private Builder() {
        }

        public final Builder from(AcceptUrlAuth instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AcceptUrlAuth instance;
            long bits = 0L;
            if (object instanceof AcceptUrlAuth) {
                String urlValue;
                Integer msgIdValue;
                instance = (AcceptUrlAuth)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.writeAllowed(instance.writeAllowed());
                InputPeer peerValue = instance.peer();
                if (peerValue != null) {
                    this.peer(peerValue);
                }
                this.flags(instance.flags());
                Integer buttonIdValue = instance.buttonId();
                if (buttonIdValue != null) {
                    this.buttonId(buttonIdValue);
                }
                if ((msgIdValue = instance.msgId()) != null) {
                    this.msgId(msgIdValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder writeAllowed(boolean writeAllowed) {
            this.writeAllowed = writeAllowed;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(@Nullable InputPeer peer) {
            this.peer = peer;
            return this;
        }

        public final Builder msgId(@Nullable Integer msgId) {
            this.msgId = msgId;
            return this;
        }

        public final Builder buttonId(@Nullable Integer buttonId) {
            this.buttonId = buttonId;
            return this;
        }

        public final Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public ImmutableAcceptUrlAuth build() {
            return ImmutableAcceptUrlAuth.validate(new ImmutableAcceptUrlAuth(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean writeAllowedIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte writeAllowedBuildStage = 0;
        private boolean writeAllowed;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableAcceptUrlAuth.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableAcceptUrlAuth.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean writeAllowed() {
            if (this.writeAllowedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeAllowedBuildStage == 0) {
                this.writeAllowedBuildStage = (byte)-1;
                this.writeAllowed = ImmutableAcceptUrlAuth.this.writeAllowedInitialize();
                this.writeAllowedBuildStage = 1;
            }
            return this.writeAllowed;
        }

        void writeAllowed(boolean writeAllowed) {
            this.writeAllowed = writeAllowed;
            this.writeAllowedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.writeAllowedBuildStage == -1) {
                attributes.add("writeAllowed");
            }
            return "Cannot build AcceptUrlAuth, attribute initializers form cycle " + attributes;
        }
    }
}

