/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.AddChatUser;

public final class ImmutableAddChatUser
implements AddChatUser {
    private final int identifier;
    private final long chatId;
    private final InputUser userId;
    private final int fwdLimit;

    private ImmutableAddChatUser(long chatId, InputUser userId, int fwdLimit) {
        this.chatId = chatId;
        this.userId = Objects.requireNonNull(userId, "userId");
        this.fwdLimit = fwdLimit;
        this.identifier = AddChatUser.super.identifier();
    }

    private ImmutableAddChatUser(Builder builder) {
        this.chatId = builder.chatId;
        this.userId = builder.userId;
        this.fwdLimit = builder.fwdLimit;
        this.identifier = builder.identifierIsSet() ? builder.identifier : AddChatUser.super.identifier();
    }

    private ImmutableAddChatUser(int identifier, long chatId, InputUser userId, int fwdLimit) {
        this.identifier = identifier;
        this.chatId = chatId;
        this.userId = userId;
        this.fwdLimit = fwdLimit;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public int fwdLimit() {
        return this.fwdLimit;
    }

    public final ImmutableAddChatUser withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAddChatUser(value, this.chatId, this.userId, this.fwdLimit);
    }

    public final ImmutableAddChatUser withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableAddChatUser(this.identifier, value, this.userId, this.fwdLimit);
    }

    public final ImmutableAddChatUser withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableAddChatUser(this.identifier, this.chatId, newValue, this.fwdLimit);
    }

    public final ImmutableAddChatUser withFwdLimit(int value) {
        if (this.fwdLimit == value) {
            return this;
        }
        return new ImmutableAddChatUser(this.identifier, this.chatId, this.userId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAddChatUser && this.equalTo(0, (ImmutableAddChatUser)another);
    }

    private boolean equalTo(int synthetic, ImmutableAddChatUser another) {
        return this.identifier == another.identifier && this.chatId == another.chatId && this.userId.equals(another.userId) && this.fwdLimit == another.fwdLimit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.fwdLimit;
        return h;
    }

    public String toString() {
        return "AddChatUser{identifier=" + this.identifier + ", chatId=" + this.chatId + ", userId=" + this.userId + ", fwdLimit=" + this.fwdLimit + "}";
    }

    public static ImmutableAddChatUser of(long chatId, InputUser userId, int fwdLimit) {
        return new ImmutableAddChatUser(chatId, userId, fwdLimit);
    }

    public static ImmutableAddChatUser copyOf(AddChatUser instance) {
        if (instance instanceof ImmutableAddChatUser) {
            return (ImmutableAddChatUser)instance;
        }
        return ImmutableAddChatUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_FWD_LIMIT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long chatId;
        private InputUser userId;
        private int fwdLimit;

        private Builder() {
        }

        public final Builder from(AddChatUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AddChatUser instance;
            long bits = 0L;
            if (object instanceof AddChatUser) {
                instance = (AddChatUser)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.fwdLimit(instance.fwdLimit());
                this.chatId(instance.chatId());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder fwdLimit(int fwdLimit) {
            this.fwdLimit = fwdLimit;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableAddChatUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAddChatUser(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("fwdLimit");
            }
            return "Cannot build AddChatUser, some of required attributes are not set " + attributes;
        }
    }
}

