/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.CheckChatInvite;

public final class ImmutableCheckChatInvite
implements CheckChatInvite {
    private final int identifier;
    private final String hash;

    private ImmutableCheckChatInvite(String hash) {
        this.hash = Objects.requireNonNull(hash, "hash");
        this.identifier = CheckChatInvite.super.identifier();
    }

    private ImmutableCheckChatInvite(Builder builder) {
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : CheckChatInvite.super.identifier();
    }

    private ImmutableCheckChatInvite(int identifier, String hash) {
        this.identifier = identifier;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String hash() {
        return this.hash;
    }

    public final ImmutableCheckChatInvite withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCheckChatInvite(value, this.hash);
    }

    public final ImmutableCheckChatInvite withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckChatInvite(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckChatInvite && this.equalTo(0, (ImmutableCheckChatInvite)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckChatInvite another) {
        return this.identifier == another.identifier && this.hash.equals(another.hash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.hash.hashCode();
        return h;
    }

    public String toString() {
        return "CheckChatInvite{identifier=" + this.identifier + ", hash=" + this.hash + "}";
    }

    public static ImmutableCheckChatInvite of(String hash) {
        return new ImmutableCheckChatInvite(hash);
    }

    public static ImmutableCheckChatInvite copyOf(CheckChatInvite instance) {
        if (instance instanceof ImmutableCheckChatInvite) {
            return (ImmutableCheckChatInvite)instance;
        }
        return ImmutableCheckChatInvite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String hash;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CheckChatInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof CheckChatInvite) {
                instance = (CheckChatInvite)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCheckChatInvite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckChatInvite(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build CheckChatInvite, some of required attributes are not set " + attributes;
        }
    }
}

