/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.CheckHistoryImport;

public final class ImmutableCheckHistoryImport
implements CheckHistoryImport {
    private final int identifier;
    private final String importHead;

    private ImmutableCheckHistoryImport(String importHead) {
        this.importHead = Objects.requireNonNull(importHead, "importHead");
        this.identifier = CheckHistoryImport.super.identifier();
    }

    private ImmutableCheckHistoryImport(Builder builder) {
        this.importHead = builder.importHead;
        this.identifier = builder.identifierIsSet() ? builder.identifier : CheckHistoryImport.super.identifier();
    }

    private ImmutableCheckHistoryImport(int identifier, String importHead) {
        this.identifier = identifier;
        this.importHead = importHead;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String importHead() {
        return this.importHead;
    }

    public final ImmutableCheckHistoryImport withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCheckHistoryImport(value, this.importHead);
    }

    public final ImmutableCheckHistoryImport withImportHead(String value) {
        String newValue = Objects.requireNonNull(value, "importHead");
        if (this.importHead.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckHistoryImport(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckHistoryImport && this.equalTo(0, (ImmutableCheckHistoryImport)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckHistoryImport another) {
        return this.identifier == another.identifier && this.importHead.equals(another.importHead);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.importHead.hashCode();
        return h;
    }

    public String toString() {
        return "CheckHistoryImport{identifier=" + this.identifier + ", importHead=" + this.importHead + "}";
    }

    public static ImmutableCheckHistoryImport of(String importHead) {
        return new ImmutableCheckHistoryImport(importHead);
    }

    public static ImmutableCheckHistoryImport copyOf(CheckHistoryImport instance) {
        if (instance instanceof ImmutableCheckHistoryImport) {
            return (ImmutableCheckHistoryImport)instance;
        }
        return ImmutableCheckHistoryImport.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_IMPORT_HEAD = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String importHead;

        private Builder() {
        }

        public final Builder from(CheckHistoryImport instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CheckHistoryImport instance;
            long bits = 0L;
            if (object instanceof CheckHistoryImport) {
                instance = (CheckHistoryImport)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.importHead(instance.importHead());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder importHead(String importHead) {
            this.importHead = Objects.requireNonNull(importHead, "importHead");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCheckHistoryImport build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckHistoryImport(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("importHead");
            }
            return "Cannot build CheckHistoryImport, some of required attributes are not set " + attributes;
        }
    }
}

