/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ClearRecentStickers;

public final class ImmutableClearRecentStickers
implements ClearRecentStickers {
    private final int identifier;
    private final int flags;
    private final boolean attached;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableClearRecentStickers INSTANCE = ImmutableClearRecentStickers.validate(new ImmutableClearRecentStickers());

    private ImmutableClearRecentStickers() {
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.attached = this.initShim.attached();
        this.initShim = null;
    }

    private ImmutableClearRecentStickers(Builder builder) {
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.attachedIsSet()) {
            this.initShim.attached(builder.attached);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.attached = this.initShim.attached();
        this.initShim = null;
    }

    private ImmutableClearRecentStickers(int identifier, int flags, boolean attached) {
        this.identifier = identifier;
        this.flags = flags;
        this.attached = attached;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ClearRecentStickers.super.identifier();
    }

    private int flagsInitialize() {
        return ClearRecentStickers.super.flags();
    }

    private boolean attachedInitialize() {
        return ClearRecentStickers.super.attached();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean attached() {
        InitShim shim = this.initShim;
        return shim != null ? shim.attached() : this.attached;
    }

    public final ImmutableClearRecentStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableClearRecentStickers.validate(new ImmutableClearRecentStickers(value, this.flags, this.attached));
    }

    public final ImmutableClearRecentStickers withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableClearRecentStickers.validate(new ImmutableClearRecentStickers(this.identifier, value, this.attached));
    }

    public final ImmutableClearRecentStickers withAttached(boolean value) {
        if (this.attached == value) {
            return this;
        }
        return ImmutableClearRecentStickers.validate(new ImmutableClearRecentStickers(this.identifier, this.flags, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClearRecentStickers && this.equalTo(0, (ImmutableClearRecentStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableClearRecentStickers another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.attached == another.attached;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.attached);
        return h;
    }

    public String toString() {
        return "ClearRecentStickers{identifier=" + this.identifier + ", flags=" + this.flags + ", attached=" + this.attached + "}";
    }

    public static ImmutableClearRecentStickers of() {
        return INSTANCE;
    }

    private static ImmutableClearRecentStickers validate(ImmutableClearRecentStickers instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableClearRecentStickers copyOf(ClearRecentStickers instance) {
        if (instance instanceof ImmutableClearRecentStickers) {
            return (ImmutableClearRecentStickers)instance;
        }
        return ImmutableClearRecentStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_ATTACHED = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean attached;

        private Builder() {
        }

        public final Builder from(ClearRecentStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ClearRecentStickers instance;
            long bits = 0L;
            if (object instanceof ClearRecentStickers) {
                instance = (ClearRecentStickers)object;
                this.flags(instance.flags());
                this.attached(instance.attached());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder attached(boolean attached) {
            this.attached = attached;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableClearRecentStickers build() {
            return ImmutableClearRecentStickers.validate(new ImmutableClearRecentStickers(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean attachedIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte attachedBuildStage = 0;
        private boolean attached;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableClearRecentStickers.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableClearRecentStickers.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean attached() {
            if (this.attachedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.attachedBuildStage == 0) {
                this.attachedBuildStage = (byte)-1;
                this.attached = ImmutableClearRecentStickers.this.attachedInitialize();
                this.attachedBuildStage = 1;
            }
            return this.attached;
        }

        void attached(boolean attached) {
            this.attached = attached;
            this.attachedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.attachedBuildStage == -1) {
                attributes.add("attached");
            }
            return "Cannot build ClearRecentStickers, attribute initializers form cycle " + attributes;
        }
    }
}

