/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.CreateChat;

public final class ImmutableCreateChat
implements CreateChat {
    private final int identifier;
    private final List<InputUser> users;
    private final String title;

    private ImmutableCreateChat(String title) {
        this.title = Objects.requireNonNull(title, "title");
        this.users = Collections.emptyList();
        this.identifier = CreateChat.super.identifier();
    }

    private ImmutableCreateChat(Builder builder) {
        this.users = ImmutableCreateChat.createUnmodifiableList(true, builder.users);
        this.title = builder.title;
        this.identifier = builder.identifierIsSet() ? builder.identifier : CreateChat.super.identifier();
    }

    private ImmutableCreateChat(int identifier, List<InputUser> users, String title) {
        this.identifier = identifier;
        this.users = users;
        this.title = title;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<InputUser> users() {
        return this.users;
    }

    @Override
    public String title() {
        return this.title;
    }

    public final ImmutableCreateChat withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCreateChat(value, this.users, this.title);
    }

    public final ImmutableCreateChat withUsers(InputUser ... elements) {
        List<InputUser> newValue = ImmutableCreateChat.createUnmodifiableList(false, ImmutableCreateChat.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCreateChat(this.identifier, newValue, this.title);
    }

    public final ImmutableCreateChat withUsers(Iterable<? extends InputUser> elements) {
        if (this.users == elements) {
            return this;
        }
        List<InputUser> newValue = ImmutableCreateChat.createUnmodifiableList(false, ImmutableCreateChat.createSafeList(elements, true, false));
        return new ImmutableCreateChat(this.identifier, newValue, this.title);
    }

    public final ImmutableCreateChat withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateChat(this.identifier, this.users, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateChat && this.equalTo(0, (ImmutableCreateChat)another);
    }

    private boolean equalTo(int synthetic, ImmutableCreateChat another) {
        return this.identifier == another.identifier && this.users.equals(another.users) && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.users.hashCode();
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return "CreateChat{identifier=" + this.identifier + ", users=" + this.users + ", title=" + this.title + "}";
    }

    public static ImmutableCreateChat of(String title) {
        return new ImmutableCreateChat(title);
    }

    public static ImmutableCreateChat copyOf(CreateChat instance) {
        if (instance instanceof ImmutableCreateChat) {
            return (ImmutableCreateChat)instance;
        }
        return ImmutableCreateChat.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private List<InputUser> users = new ArrayList<InputUser>();
        private String title;

        private Builder() {
        }

        public final Builder from(CreateChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CreateChat instance;
            long bits = 0L;
            if (object instanceof CreateChat) {
                instance = (CreateChat)object;
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addUser(InputUser element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(InputUser ... elements) {
            for (InputUser element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends InputUser> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends InputUser> elements) {
            for (InputUser inputUser : elements) {
                this.users.add(Objects.requireNonNull(inputUser, "users element"));
            }
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCreateChat build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateChat(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build CreateChat, some of required attributes are not set " + attributes;
        }
    }
}

