/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.DeleteChat;

public final class ImmutableDeleteChat
implements DeleteChat {
    private final int identifier;
    private final long chatId;

    private ImmutableDeleteChat(long chatId) {
        this.chatId = chatId;
        this.identifier = DeleteChat.super.identifier();
    }

    private ImmutableDeleteChat(Builder builder) {
        this.chatId = builder.chatId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : DeleteChat.super.identifier();
    }

    private ImmutableDeleteChat(int identifier, long chatId) {
        this.identifier = identifier;
        this.chatId = chatId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    public final ImmutableDeleteChat withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDeleteChat(value, this.chatId);
    }

    public final ImmutableDeleteChat withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableDeleteChat(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteChat && this.equalTo(0, (ImmutableDeleteChat)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteChat another) {
        return this.identifier == another.identifier && this.chatId == another.chatId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        return h;
    }

    public String toString() {
        return "DeleteChat{identifier=" + this.identifier + ", chatId=" + this.chatId + "}";
    }

    public static ImmutableDeleteChat of(long chatId) {
        return new ImmutableDeleteChat(chatId);
    }

    public static ImmutableDeleteChat copyOf(DeleteChat instance) {
        if (instance instanceof ImmutableDeleteChat) {
            return (ImmutableDeleteChat)instance;
        }
        return ImmutableDeleteChat.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long chatId;

        private Builder() {
        }

        public final Builder from(DeleteChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DeleteChat instance;
            long bits = 0L;
            if (object instanceof DeleteChat) {
                instance = (DeleteChat)object;
                this.chatId(instance.chatId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDeleteChat build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeleteChat(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            return "Cannot build DeleteChat, some of required attributes are not set " + attributes;
        }
    }
}

