/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.DeleteChatUser;

public final class ImmutableDeleteChatUser
implements DeleteChatUser {
    private final int identifier;
    private final int flags;
    private final boolean revokeHistory;
    private final long chatId;
    private final InputUser userId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDeleteChatUser(long chatId, InputUser userId) {
        this.chatId = chatId;
        this.userId = Objects.requireNonNull(userId, "userId");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.revokeHistory = this.initShim.revokeHistory();
        this.initShim = null;
    }

    private ImmutableDeleteChatUser(Builder builder) {
        this.chatId = builder.chatId;
        this.userId = builder.userId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.revokeHistoryIsSet()) {
            this.initShim.revokeHistory(builder.revokeHistory);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.revokeHistory = this.initShim.revokeHistory();
        this.initShim = null;
    }

    private ImmutableDeleteChatUser(int identifier, int flags, boolean revokeHistory, long chatId, InputUser userId) {
        this.identifier = identifier;
        this.flags = flags;
        this.revokeHistory = revokeHistory;
        this.chatId = chatId;
        this.userId = userId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DeleteChatUser.super.identifier();
    }

    private int flagsInitialize() {
        return DeleteChatUser.super.flags();
    }

    private boolean revokeHistoryInitialize() {
        return DeleteChatUser.super.revokeHistory();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean revokeHistory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.revokeHistory() : this.revokeHistory;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    public final ImmutableDeleteChatUser withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDeleteChatUser(value, this.flags, this.revokeHistory, this.chatId, this.userId);
    }

    public final ImmutableDeleteChatUser withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDeleteChatUser(this.identifier, value, this.revokeHistory, this.chatId, this.userId);
    }

    public final ImmutableDeleteChatUser withRevokeHistory(boolean value) {
        if (this.revokeHistory == value) {
            return this;
        }
        return new ImmutableDeleteChatUser(this.identifier, this.flags, value, this.chatId, this.userId);
    }

    public final ImmutableDeleteChatUser withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableDeleteChatUser(this.identifier, this.flags, this.revokeHistory, value, this.userId);
    }

    public final ImmutableDeleteChatUser withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableDeleteChatUser(this.identifier, this.flags, this.revokeHistory, this.chatId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteChatUser && this.equalTo(0, (ImmutableDeleteChatUser)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteChatUser another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.revokeHistory == another.revokeHistory && this.chatId == another.chatId && this.userId.equals(another.userId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.revokeHistory);
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + this.userId.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteChatUser{identifier=" + this.identifier + ", flags=" + this.flags + ", revokeHistory=" + this.revokeHistory + ", chatId=" + this.chatId + ", userId=" + this.userId + "}";
    }

    public static ImmutableDeleteChatUser of(long chatId, InputUser userId) {
        return new ImmutableDeleteChatUser(chatId, userId);
    }

    public static ImmutableDeleteChatUser copyOf(DeleteChatUser instance) {
        if (instance instanceof ImmutableDeleteChatUser) {
            return (ImmutableDeleteChatUser)instance;
        }
        return ImmutableDeleteChatUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_REVOKE_HISTORY = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean revokeHistory;
        private long chatId;
        private InputUser userId;

        private Builder() {
        }

        public final Builder from(DeleteChatUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DeleteChatUser instance;
            long bits = 0L;
            if (object instanceof DeleteChatUser) {
                instance = (DeleteChatUser)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.chatId(instance.chatId());
                this.revokeHistory(instance.revokeHistory());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder revokeHistory(boolean revokeHistory) {
            this.revokeHistory = revokeHistory;
            this.optBits |= 4L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDeleteChatUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeleteChatUser(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean revokeHistoryIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build DeleteChatUser, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte revokeHistoryBuildStage = 0;
        private boolean revokeHistory;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDeleteChatUser.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDeleteChatUser.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean revokeHistory() {
            if (this.revokeHistoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokeHistoryBuildStage == 0) {
                this.revokeHistoryBuildStage = (byte)-1;
                this.revokeHistory = ImmutableDeleteChatUser.this.revokeHistoryInitialize();
                this.revokeHistoryBuildStage = 1;
            }
            return this.revokeHistory;
        }

        void revokeHistory(boolean revokeHistory) {
            this.revokeHistory = revokeHistory;
            this.revokeHistoryBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.revokeHistoryBuildStage == -1) {
                attributes.add("revokeHistory");
            }
            return "Cannot build DeleteChatUser, attribute initializers form cycle " + attributes;
        }
    }
}

