/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.DeleteHistory;

public final class ImmutableDeleteHistory
implements DeleteHistory {
    private final int identifier;
    private final int flags;
    private final boolean justClear;
    private final boolean revoke;
    private final InputPeer peer;
    private final int maxId;
    @Nullable
    private final Integer minDate;
    @Nullable
    private final Integer maxDate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDeleteHistory(InputPeer peer, int maxId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.maxId = maxId;
        this.minDate = null;
        this.maxDate = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.justClear = this.initShim.justClear();
        this.revoke = this.initShim.revoke();
        this.initShim = null;
    }

    private ImmutableDeleteHistory(Builder builder) {
        this.peer = builder.peer;
        this.maxId = builder.maxId;
        this.minDate = builder.minDate;
        this.maxDate = builder.maxDate;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.justClearIsSet()) {
            this.initShim.justClear(builder.justClear);
        }
        if (builder.revokeIsSet()) {
            this.initShim.revoke(builder.revoke);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.justClear = this.initShim.justClear();
        this.revoke = this.initShim.revoke();
        this.initShim = null;
    }

    private ImmutableDeleteHistory(int identifier, int flags, boolean justClear, boolean revoke, InputPeer peer, int maxId, @Nullable Integer minDate, @Nullable Integer maxDate) {
        this.identifier = identifier;
        this.flags = flags;
        this.justClear = justClear;
        this.revoke = revoke;
        this.peer = peer;
        this.maxId = maxId;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DeleteHistory.super.identifier();
    }

    private int flagsInitialize() {
        return DeleteHistory.super.flags();
    }

    private boolean justClearInitialize() {
        return DeleteHistory.super.justClear();
    }

    private boolean revokeInitialize() {
        return DeleteHistory.super.revoke();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean justClear() {
        InitShim shim = this.initShim;
        return shim != null ? shim.justClear() : this.justClear;
    }

    @Override
    public boolean revoke() {
        InitShim shim = this.initShim;
        return shim != null ? shim.revoke() : this.revoke;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    @Override
    @Nullable
    public Integer minDate() {
        return this.minDate;
    }

    @Override
    @Nullable
    public Integer maxDate() {
        return this.maxDate;
    }

    public final ImmutableDeleteHistory withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDeleteHistory(value, this.flags, this.justClear, this.revoke, this.peer, this.maxId, this.minDate, this.maxDate);
    }

    public final ImmutableDeleteHistory withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDeleteHistory(this.identifier, value, this.justClear, this.revoke, this.peer, this.maxId, this.minDate, this.maxDate);
    }

    public final ImmutableDeleteHistory withJustClear(boolean value) {
        if (this.justClear == value) {
            return this;
        }
        return new ImmutableDeleteHistory(this.identifier, this.flags, value, this.revoke, this.peer, this.maxId, this.minDate, this.maxDate);
    }

    public final ImmutableDeleteHistory withRevoke(boolean value) {
        if (this.revoke == value) {
            return this;
        }
        return new ImmutableDeleteHistory(this.identifier, this.flags, this.justClear, value, this.peer, this.maxId, this.minDate, this.maxDate);
    }

    public final ImmutableDeleteHistory withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableDeleteHistory(this.identifier, this.flags, this.justClear, this.revoke, newValue, this.maxId, this.minDate, this.maxDate);
    }

    public final ImmutableDeleteHistory withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableDeleteHistory(this.identifier, this.flags, this.justClear, this.revoke, this.peer, value, this.minDate, this.maxDate);
    }

    public final ImmutableDeleteHistory withMinDate(@Nullable Integer value) {
        if (Objects.equals(this.minDate, value)) {
            return this;
        }
        return new ImmutableDeleteHistory(this.identifier, this.flags, this.justClear, this.revoke, this.peer, this.maxId, value, this.maxDate);
    }

    public final ImmutableDeleteHistory withMaxDate(@Nullable Integer value) {
        if (Objects.equals(this.maxDate, value)) {
            return this;
        }
        return new ImmutableDeleteHistory(this.identifier, this.flags, this.justClear, this.revoke, this.peer, this.maxId, this.minDate, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteHistory && this.equalTo(0, (ImmutableDeleteHistory)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteHistory another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.justClear == another.justClear && this.revoke == another.revoke && this.peer.equals(another.peer) && this.maxId == another.maxId && Objects.equals(this.minDate, another.minDate) && Objects.equals(this.maxDate, another.maxDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.justClear);
        h += (h << 5) + Boolean.hashCode(this.revoke);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.maxId;
        h += (h << 5) + Objects.hashCode(this.minDate);
        h += (h << 5) + Objects.hashCode(this.maxDate);
        return h;
    }

    public String toString() {
        return "DeleteHistory{identifier=" + this.identifier + ", flags=" + this.flags + ", justClear=" + this.justClear + ", revoke=" + this.revoke + ", peer=" + this.peer + ", maxId=" + this.maxId + ", minDate=" + this.minDate + ", maxDate=" + this.maxDate + "}";
    }

    public static ImmutableDeleteHistory of(InputPeer peer, int maxId) {
        return new ImmutableDeleteHistory(peer, maxId);
    }

    public static ImmutableDeleteHistory copyOf(DeleteHistory instance) {
        if (instance instanceof ImmutableDeleteHistory) {
            return (ImmutableDeleteHistory)instance;
        }
        return ImmutableDeleteHistory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MAX_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_JUST_CLEAR = 4L;
        private static final long OPT_BIT_REVOKE = 8L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean justClear;
        private boolean revoke;
        private InputPeer peer;
        private int maxId;
        private Integer minDate;
        private Integer maxDate;

        private Builder() {
        }

        public final Builder from(DeleteHistory instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DeleteHistory instance;
            long bits = 0L;
            if (object instanceof DeleteHistory) {
                instance = (DeleteHistory)object;
                this.justClear(instance.justClear());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
                Integer minDateValue = instance.minDate();
                if (minDateValue != null) {
                    this.minDate(minDateValue);
                }
                this.peer(instance.peer());
                this.flags(instance.flags());
                this.revoke(instance.revoke());
                Integer maxDateValue = instance.maxDate();
                if (maxDateValue != null) {
                    this.maxDate(maxDateValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder justClear(boolean justClear) {
            this.justClear = justClear;
            this.optBits |= 4L;
            return this;
        }

        public final Builder revoke(boolean revoke) {
            this.revoke = revoke;
            this.optBits |= 8L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder minDate(@Nullable Integer minDate) {
            this.minDate = minDate;
            return this;
        }

        public final Builder maxDate(@Nullable Integer maxDate) {
            this.maxDate = maxDate;
            return this;
        }

        public ImmutableDeleteHistory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeleteHistory(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean justClearIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean revokeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxId");
            }
            return "Cannot build DeleteHistory, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte justClearBuildStage = 0;
        private boolean justClear;
        private byte revokeBuildStage = 0;
        private boolean revoke;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDeleteHistory.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDeleteHistory.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean justClear() {
            if (this.justClearBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.justClearBuildStage == 0) {
                this.justClearBuildStage = (byte)-1;
                this.justClear = ImmutableDeleteHistory.this.justClearInitialize();
                this.justClearBuildStage = 1;
            }
            return this.justClear;
        }

        void justClear(boolean justClear) {
            this.justClear = justClear;
            this.justClearBuildStage = 1;
        }

        boolean revoke() {
            if (this.revokeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokeBuildStage == 0) {
                this.revokeBuildStage = (byte)-1;
                this.revoke = ImmutableDeleteHistory.this.revokeInitialize();
                this.revokeBuildStage = 1;
            }
            return this.revoke;
        }

        void revoke(boolean revoke) {
            this.revoke = revoke;
            this.revokeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.justClearBuildStage == -1) {
                attributes.add("justClear");
            }
            if (this.revokeBuildStage == -1) {
                attributes.add("revoke");
            }
            return "Cannot build DeleteHistory, attribute initializers form cycle " + attributes;
        }
    }
}

