/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.DeleteMessages;

public final class ImmutableDeleteMessages
implements DeleteMessages {
    private final int identifier;
    private final int flags;
    private final boolean revoke;
    private final List<Integer> id;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDeleteMessages(Builder builder) {
        this.id = ImmutableDeleteMessages.createUnmodifiableList(true, builder.id);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.revokeIsSet()) {
            this.initShim.revoke(builder.revoke);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.revoke = this.initShim.revoke();
        this.initShim = null;
    }

    private ImmutableDeleteMessages(int identifier, int flags, boolean revoke, List<Integer> id) {
        this.identifier = identifier;
        this.flags = flags;
        this.revoke = revoke;
        this.id = id;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DeleteMessages.super.identifier();
    }

    private int flagsInitialize() {
        return DeleteMessages.super.flags();
    }

    private boolean revokeInitialize() {
        return DeleteMessages.super.revoke();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean revoke() {
        InitShim shim = this.initShim;
        return shim != null ? shim.revoke() : this.revoke;
    }

    @Override
    public List<Integer> id() {
        return this.id;
    }

    public final ImmutableDeleteMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDeleteMessages(value, this.flags, this.revoke, this.id);
    }

    public final ImmutableDeleteMessages withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDeleteMessages(this.identifier, value, this.revoke, this.id);
    }

    public final ImmutableDeleteMessages withRevoke(boolean value) {
        if (this.revoke == value) {
            return this;
        }
        return new ImmutableDeleteMessages(this.identifier, this.flags, value, this.id);
    }

    public final ImmutableDeleteMessages withId(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableDeleteMessages.createUnmodifiableList(false, wrappedList);
        return new ImmutableDeleteMessages(this.identifier, this.flags, this.revoke, newValue);
    }

    public final ImmutableDeleteMessages withId(Iterable<Integer> elements) {
        if (this.id == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableDeleteMessages.createUnmodifiableList(false, ImmutableDeleteMessages.createSafeList(elements, true, false));
        return new ImmutableDeleteMessages(this.identifier, this.flags, this.revoke, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteMessages && this.equalTo(0, (ImmutableDeleteMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteMessages another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.revoke == another.revoke && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.revoke);
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteMessages{identifier=" + this.identifier + ", flags=" + this.flags + ", revoke=" + this.revoke + ", id=" + this.id + "}";
    }

    public static ImmutableDeleteMessages copyOf(DeleteMessages instance) {
        if (instance instanceof ImmutableDeleteMessages) {
            return (ImmutableDeleteMessages)instance;
        }
        return ImmutableDeleteMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_REVOKE = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean revoke;
        private List<Integer> id = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(DeleteMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DeleteMessages instance;
            long bits = 0L;
            if (object instanceof DeleteMessages) {
                instance = (DeleteMessages)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.revoke(instance.revoke());
                this.addAllId(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder revoke(boolean revoke) {
            this.revoke = revoke;
            this.optBits |= 4L;
            return this;
        }

        public final Builder addId(int element) {
            this.id.add(element);
            return this;
        }

        public final Builder addId(int ... elements) {
            for (int element : elements) {
                this.id.add(element);
            }
            return this;
        }

        public final Builder id(Iterable<Integer> elements) {
            this.id.clear();
            return this.addAllId(elements);
        }

        public final Builder addAllId(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.id.add(Objects.requireNonNull(element, "id element"));
            }
            return this;
        }

        public ImmutableDeleteMessages build() {
            return new ImmutableDeleteMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean revokeIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte revokeBuildStage = 0;
        private boolean revoke;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDeleteMessages.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDeleteMessages.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean revoke() {
            if (this.revokeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokeBuildStage == 0) {
                this.revokeBuildStage = (byte)-1;
                this.revoke = ImmutableDeleteMessages.this.revokeInitialize();
                this.revokeBuildStage = 1;
            }
            return this.revoke;
        }

        void revoke(boolean revoke) {
            this.revoke = revoke;
            this.revokeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.revokeBuildStage == -1) {
                attributes.add("revoke");
            }
            return "Cannot build DeleteMessages, attribute initializers form cycle " + attributes;
        }
    }
}

