/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.DeletePhoneCallHistory;

public final class ImmutableDeletePhoneCallHistory
implements DeletePhoneCallHistory {
    private final int identifier;
    private final int flags;
    private final boolean revoke;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableDeletePhoneCallHistory INSTANCE = ImmutableDeletePhoneCallHistory.validate(new ImmutableDeletePhoneCallHistory());

    private ImmutableDeletePhoneCallHistory() {
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.revoke = this.initShim.revoke();
        this.initShim = null;
    }

    private ImmutableDeletePhoneCallHistory(Builder builder) {
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.revokeIsSet()) {
            this.initShim.revoke(builder.revoke);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.revoke = this.initShim.revoke();
        this.initShim = null;
    }

    private ImmutableDeletePhoneCallHistory(int identifier, int flags, boolean revoke) {
        this.identifier = identifier;
        this.flags = flags;
        this.revoke = revoke;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DeletePhoneCallHistory.super.identifier();
    }

    private int flagsInitialize() {
        return DeletePhoneCallHistory.super.flags();
    }

    private boolean revokeInitialize() {
        return DeletePhoneCallHistory.super.revoke();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean revoke() {
        InitShim shim = this.initShim;
        return shim != null ? shim.revoke() : this.revoke;
    }

    public final ImmutableDeletePhoneCallHistory withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableDeletePhoneCallHistory.validate(new ImmutableDeletePhoneCallHistory(value, this.flags, this.revoke));
    }

    public final ImmutableDeletePhoneCallHistory withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableDeletePhoneCallHistory.validate(new ImmutableDeletePhoneCallHistory(this.identifier, value, this.revoke));
    }

    public final ImmutableDeletePhoneCallHistory withRevoke(boolean value) {
        if (this.revoke == value) {
            return this;
        }
        return ImmutableDeletePhoneCallHistory.validate(new ImmutableDeletePhoneCallHistory(this.identifier, this.flags, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeletePhoneCallHistory && this.equalTo(0, (ImmutableDeletePhoneCallHistory)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeletePhoneCallHistory another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.revoke == another.revoke;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.revoke);
        return h;
    }

    public String toString() {
        return "DeletePhoneCallHistory{identifier=" + this.identifier + ", flags=" + this.flags + ", revoke=" + this.revoke + "}";
    }

    public static ImmutableDeletePhoneCallHistory of() {
        return INSTANCE;
    }

    private static ImmutableDeletePhoneCallHistory validate(ImmutableDeletePhoneCallHistory instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableDeletePhoneCallHistory copyOf(DeletePhoneCallHistory instance) {
        if (instance instanceof ImmutableDeletePhoneCallHistory) {
            return (ImmutableDeletePhoneCallHistory)instance;
        }
        return ImmutableDeletePhoneCallHistory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_REVOKE = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean revoke;

        private Builder() {
        }

        public final Builder from(DeletePhoneCallHistory instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DeletePhoneCallHistory instance;
            long bits = 0L;
            if (object instanceof DeletePhoneCallHistory) {
                instance = (DeletePhoneCallHistory)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.revoke(instance.revoke());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder revoke(boolean revoke) {
            this.revoke = revoke;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableDeletePhoneCallHistory build() {
            return ImmutableDeletePhoneCallHistory.validate(new ImmutableDeletePhoneCallHistory(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean revokeIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte revokeBuildStage = 0;
        private boolean revoke;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDeletePhoneCallHistory.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDeletePhoneCallHistory.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean revoke() {
            if (this.revokeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokeBuildStage == 0) {
                this.revokeBuildStage = (byte)-1;
                this.revoke = ImmutableDeletePhoneCallHistory.this.revokeInitialize();
                this.revokeBuildStage = 1;
            }
            return this.revoke;
        }

        void revoke(boolean revoke) {
            this.revoke = revoke;
            this.revokeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.revokeBuildStage == -1) {
                attributes.add("revoke");
            }
            return "Cannot build DeletePhoneCallHistory, attribute initializers form cycle " + attributes;
        }
    }
}

