/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.DeleteRevokedExportedChatInvites;

public final class ImmutableDeleteRevokedExportedChatInvites
implements DeleteRevokedExportedChatInvites {
    private final int identifier;
    private final InputPeer peer;
    private final InputUser adminId;

    private ImmutableDeleteRevokedExportedChatInvites(InputPeer peer, InputUser adminId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.adminId = Objects.requireNonNull(adminId, "adminId");
        this.identifier = DeleteRevokedExportedChatInvites.super.identifier();
    }

    private ImmutableDeleteRevokedExportedChatInvites(Builder builder) {
        this.peer = builder.peer;
        this.adminId = builder.adminId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : DeleteRevokedExportedChatInvites.super.identifier();
    }

    private ImmutableDeleteRevokedExportedChatInvites(int identifier, InputPeer peer, InputUser adminId) {
        this.identifier = identifier;
        this.peer = peer;
        this.adminId = adminId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public InputUser adminId() {
        return this.adminId;
    }

    public final ImmutableDeleteRevokedExportedChatInvites withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDeleteRevokedExportedChatInvites(value, this.peer, this.adminId);
    }

    public final ImmutableDeleteRevokedExportedChatInvites withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableDeleteRevokedExportedChatInvites(this.identifier, newValue, this.adminId);
    }

    public final ImmutableDeleteRevokedExportedChatInvites withAdminId(InputUser value) {
        if (this.adminId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "adminId");
        return new ImmutableDeleteRevokedExportedChatInvites(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteRevokedExportedChatInvites && this.equalTo(0, (ImmutableDeleteRevokedExportedChatInvites)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteRevokedExportedChatInvites another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.adminId.equals(another.adminId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.adminId.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteRevokedExportedChatInvites{identifier=" + this.identifier + ", peer=" + this.peer + ", adminId=" + this.adminId + "}";
    }

    public static ImmutableDeleteRevokedExportedChatInvites of(InputPeer peer, InputUser adminId) {
        return new ImmutableDeleteRevokedExportedChatInvites(peer, adminId);
    }

    public static ImmutableDeleteRevokedExportedChatInvites copyOf(DeleteRevokedExportedChatInvites instance) {
        if (instance instanceof ImmutableDeleteRevokedExportedChatInvites) {
            return (ImmutableDeleteRevokedExportedChatInvites)instance;
        }
        return ImmutableDeleteRevokedExportedChatInvites.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_ADMIN_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private InputUser adminId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DeleteRevokedExportedChatInvites instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DeleteRevokedExportedChatInvites) {
                instance = (DeleteRevokedExportedChatInvites)object;
                this.adminId(instance.adminId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder adminId(InputUser adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDeleteRevokedExportedChatInvites build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeleteRevokedExportedChatInvites(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("adminId");
            }
            return "Cannot build DeleteRevokedExportedChatInvites, some of required attributes are not set " + attributes;
        }
    }
}

