/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.DiscardEncryption;

public final class ImmutableDiscardEncryption
implements DiscardEncryption {
    private final int identifier;
    private final int flags;
    private final boolean deleteHistory;
    private final int chatId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDiscardEncryption(int chatId) {
        this.chatId = chatId;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.deleteHistory = this.initShim.deleteHistory();
        this.initShim = null;
    }

    private ImmutableDiscardEncryption(Builder builder) {
        this.chatId = builder.chatId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.deleteHistoryIsSet()) {
            this.initShim.deleteHistory(builder.deleteHistory);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.deleteHistory = this.initShim.deleteHistory();
        this.initShim = null;
    }

    private ImmutableDiscardEncryption(int identifier, int flags, boolean deleteHistory, int chatId) {
        this.identifier = identifier;
        this.flags = flags;
        this.deleteHistory = deleteHistory;
        this.chatId = chatId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DiscardEncryption.super.identifier();
    }

    private int flagsInitialize() {
        return DiscardEncryption.super.flags();
    }

    private boolean deleteHistoryInitialize() {
        return DiscardEncryption.super.deleteHistory();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean deleteHistory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deleteHistory() : this.deleteHistory;
    }

    @Override
    public int chatId() {
        return this.chatId;
    }

    public final ImmutableDiscardEncryption withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDiscardEncryption(value, this.flags, this.deleteHistory, this.chatId);
    }

    public final ImmutableDiscardEncryption withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDiscardEncryption(this.identifier, value, this.deleteHistory, this.chatId);
    }

    public final ImmutableDiscardEncryption withDeleteHistory(boolean value) {
        if (this.deleteHistory == value) {
            return this;
        }
        return new ImmutableDiscardEncryption(this.identifier, this.flags, value, this.chatId);
    }

    public final ImmutableDiscardEncryption withChatId(int value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableDiscardEncryption(this.identifier, this.flags, this.deleteHistory, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiscardEncryption && this.equalTo(0, (ImmutableDiscardEncryption)another);
    }

    private boolean equalTo(int synthetic, ImmutableDiscardEncryption another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.deleteHistory == another.deleteHistory && this.chatId == another.chatId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.deleteHistory);
        h += (h << 5) + this.chatId;
        return h;
    }

    public String toString() {
        return "DiscardEncryption{identifier=" + this.identifier + ", flags=" + this.flags + ", deleteHistory=" + this.deleteHistory + ", chatId=" + this.chatId + "}";
    }

    public static ImmutableDiscardEncryption of(int chatId) {
        return new ImmutableDiscardEncryption(chatId);
    }

    public static ImmutableDiscardEncryption copyOf(DiscardEncryption instance) {
        if (instance instanceof ImmutableDiscardEncryption) {
            return (ImmutableDiscardEncryption)instance;
        }
        return ImmutableDiscardEncryption.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_DELETE_HISTORY = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean deleteHistory;
        private int chatId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DiscardEncryption instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DiscardEncryption) {
                instance = (DiscardEncryption)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.deleteHistory(instance.deleteHistory());
                this.chatId(instance.chatId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder deleteHistory(boolean deleteHistory) {
            this.deleteHistory = deleteHistory;
            this.optBits |= 4L;
            return this;
        }

        public final Builder chatId(int chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDiscardEncryption build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiscardEncryption(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean deleteHistoryIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            return "Cannot build DiscardEncryption, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte deleteHistoryBuildStage = 0;
        private boolean deleteHistory;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDiscardEncryption.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDiscardEncryption.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean deleteHistory() {
            if (this.deleteHistoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deleteHistoryBuildStage == 0) {
                this.deleteHistoryBuildStage = (byte)-1;
                this.deleteHistory = ImmutableDiscardEncryption.this.deleteHistoryInitialize();
                this.deleteHistoryBuildStage = 1;
            }
            return this.deleteHistory;
        }

        void deleteHistory(boolean deleteHistory) {
            this.deleteHistory = deleteHistory;
            this.deleteHistoryBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.deleteHistoryBuildStage == -1) {
                attributes.add("deleteHistory");
            }
            return "Cannot build DiscardEncryption, attribute initializers form cycle " + attributes;
        }
    }
}

