/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.EditChatAdmin;

public final class ImmutableEditChatAdmin
implements EditChatAdmin {
    private final int identifier;
    private final long chatId;
    private final InputUser userId;
    private final boolean isAdmin;

    private ImmutableEditChatAdmin(long chatId, InputUser userId, boolean isAdmin) {
        this.chatId = chatId;
        this.userId = Objects.requireNonNull(userId, "userId");
        this.isAdmin = isAdmin;
        this.identifier = EditChatAdmin.super.identifier();
    }

    private ImmutableEditChatAdmin(Builder builder) {
        this.chatId = builder.chatId;
        this.userId = builder.userId;
        this.isAdmin = builder.isAdmin;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditChatAdmin.super.identifier();
    }

    private ImmutableEditChatAdmin(int identifier, long chatId, InputUser userId, boolean isAdmin) {
        this.identifier = identifier;
        this.chatId = chatId;
        this.userId = userId;
        this.isAdmin = isAdmin;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public boolean isAdmin() {
        return this.isAdmin;
    }

    public final ImmutableEditChatAdmin withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditChatAdmin(value, this.chatId, this.userId, this.isAdmin);
    }

    public final ImmutableEditChatAdmin withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableEditChatAdmin(this.identifier, value, this.userId, this.isAdmin);
    }

    public final ImmutableEditChatAdmin withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableEditChatAdmin(this.identifier, this.chatId, newValue, this.isAdmin);
    }

    public final ImmutableEditChatAdmin withIsAdmin(boolean value) {
        if (this.isAdmin == value) {
            return this;
        }
        return new ImmutableEditChatAdmin(this.identifier, this.chatId, this.userId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditChatAdmin && this.equalTo(0, (ImmutableEditChatAdmin)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditChatAdmin another) {
        return this.identifier == another.identifier && this.chatId == another.chatId && this.userId.equals(another.userId) && this.isAdmin == another.isAdmin;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isAdmin);
        return h;
    }

    public String toString() {
        return "EditChatAdmin{identifier=" + this.identifier + ", chatId=" + this.chatId + ", userId=" + this.userId + ", isAdmin=" + this.isAdmin + "}";
    }

    public static ImmutableEditChatAdmin of(long chatId, InputUser userId, boolean isAdmin) {
        return new ImmutableEditChatAdmin(chatId, userId, isAdmin);
    }

    public static ImmutableEditChatAdmin copyOf(EditChatAdmin instance) {
        if (instance instanceof ImmutableEditChatAdmin) {
            return (ImmutableEditChatAdmin)instance;
        }
        return ImmutableEditChatAdmin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_IS_ADMIN = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long chatId;
        private InputUser userId;
        private boolean isAdmin;

        private Builder() {
        }

        public final Builder from(EditChatAdmin instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EditChatAdmin instance;
            long bits = 0L;
            if (object instanceof EditChatAdmin) {
                instance = (EditChatAdmin)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.isAdmin(instance.isAdmin());
                this.chatId(instance.chatId());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder isAdmin(boolean isAdmin) {
            this.isAdmin = isAdmin;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableEditChatAdmin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditChatAdmin(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("isAdmin");
            }
            return "Cannot build EditChatAdmin, some of required attributes are not set " + attributes;
        }
    }
}

