/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChatBannedRights;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.EditChatDefaultBannedRights;

public final class ImmutableEditChatDefaultBannedRights
implements EditChatDefaultBannedRights {
    private final int identifier;
    private final InputPeer peer;
    private final ChatBannedRights bannedRights;

    private ImmutableEditChatDefaultBannedRights(InputPeer peer, ChatBannedRights bannedRights) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.bannedRights = Objects.requireNonNull(bannedRights, "bannedRights");
        this.identifier = EditChatDefaultBannedRights.super.identifier();
    }

    private ImmutableEditChatDefaultBannedRights(Builder builder) {
        this.peer = builder.peer;
        this.bannedRights = builder.bannedRights;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditChatDefaultBannedRights.super.identifier();
    }

    private ImmutableEditChatDefaultBannedRights(int identifier, InputPeer peer, ChatBannedRights bannedRights) {
        this.identifier = identifier;
        this.peer = peer;
        this.bannedRights = bannedRights;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public ChatBannedRights bannedRights() {
        return this.bannedRights;
    }

    public final ImmutableEditChatDefaultBannedRights withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditChatDefaultBannedRights(value, this.peer, this.bannedRights);
    }

    public final ImmutableEditChatDefaultBannedRights withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableEditChatDefaultBannedRights(this.identifier, newValue, this.bannedRights);
    }

    public final ImmutableEditChatDefaultBannedRights withBannedRights(ChatBannedRights value) {
        if (this.bannedRights == value) {
            return this;
        }
        ChatBannedRights newValue = Objects.requireNonNull(value, "bannedRights");
        return new ImmutableEditChatDefaultBannedRights(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditChatDefaultBannedRights && this.equalTo(0, (ImmutableEditChatDefaultBannedRights)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditChatDefaultBannedRights another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.bannedRights.equals(another.bannedRights);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.bannedRights.hashCode();
        return h;
    }

    public String toString() {
        return "EditChatDefaultBannedRights{identifier=" + this.identifier + ", peer=" + this.peer + ", bannedRights=" + this.bannedRights + "}";
    }

    public static ImmutableEditChatDefaultBannedRights of(InputPeer peer, ChatBannedRights bannedRights) {
        return new ImmutableEditChatDefaultBannedRights(peer, bannedRights);
    }

    public static ImmutableEditChatDefaultBannedRights copyOf(EditChatDefaultBannedRights instance) {
        if (instance instanceof ImmutableEditChatDefaultBannedRights) {
            return (ImmutableEditChatDefaultBannedRights)instance;
        }
        return ImmutableEditChatDefaultBannedRights.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_BANNED_RIGHTS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private ChatBannedRights bannedRights;

        private Builder() {
        }

        public final Builder from(EditChatDefaultBannedRights instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EditChatDefaultBannedRights instance;
            long bits = 0L;
            if (object instanceof EditChatDefaultBannedRights) {
                instance = (EditChatDefaultBannedRights)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.bannedRights(instance.bannedRights());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder bannedRights(ChatBannedRights bannedRights) {
            this.bannedRights = Objects.requireNonNull(bannedRights, "bannedRights");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEditChatDefaultBannedRights build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditChatDefaultBannedRights(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bannedRights");
            }
            return "Cannot build EditChatDefaultBannedRights, some of required attributes are not set " + attributes;
        }
    }
}

