/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputChatPhoto;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.EditChatPhoto;

public final class ImmutableEditChatPhoto
implements EditChatPhoto {
    private final int identifier;
    private final long chatId;
    private final InputChatPhoto photo;

    private ImmutableEditChatPhoto(long chatId, InputChatPhoto photo) {
        this.chatId = chatId;
        this.photo = Objects.requireNonNull(photo, "photo");
        this.identifier = EditChatPhoto.super.identifier();
    }

    private ImmutableEditChatPhoto(Builder builder) {
        this.chatId = builder.chatId;
        this.photo = builder.photo;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditChatPhoto.super.identifier();
    }

    private ImmutableEditChatPhoto(int identifier, long chatId, InputChatPhoto photo) {
        this.identifier = identifier;
        this.chatId = chatId;
        this.photo = photo;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public InputChatPhoto photo() {
        return this.photo;
    }

    public final ImmutableEditChatPhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditChatPhoto(value, this.chatId, this.photo);
    }

    public final ImmutableEditChatPhoto withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableEditChatPhoto(this.identifier, value, this.photo);
    }

    public final ImmutableEditChatPhoto withPhoto(InputChatPhoto value) {
        if (this.photo == value) {
            return this;
        }
        InputChatPhoto newValue = Objects.requireNonNull(value, "photo");
        return new ImmutableEditChatPhoto(this.identifier, this.chatId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditChatPhoto && this.equalTo(0, (ImmutableEditChatPhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditChatPhoto another) {
        return this.identifier == another.identifier && this.chatId == another.chatId && this.photo.equals(another.photo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + this.photo.hashCode();
        return h;
    }

    public String toString() {
        return "EditChatPhoto{identifier=" + this.identifier + ", chatId=" + this.chatId + ", photo=" + this.photo + "}";
    }

    public static ImmutableEditChatPhoto of(long chatId, InputChatPhoto photo) {
        return new ImmutableEditChatPhoto(chatId, photo);
    }

    public static ImmutableEditChatPhoto copyOf(EditChatPhoto instance) {
        if (instance instanceof ImmutableEditChatPhoto) {
            return (ImmutableEditChatPhoto)instance;
        }
        return ImmutableEditChatPhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_PHOTO = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long chatId;
        private InputChatPhoto photo;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EditChatPhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EditChatPhoto) {
                instance = (EditChatPhoto)object;
                this.chatId(instance.chatId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.photo(instance.photo());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder photo(InputChatPhoto photo) {
            this.photo = Objects.requireNonNull(photo, "photo");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEditChatPhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditChatPhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("photo");
            }
            return "Cannot build EditChatPhoto, some of required attributes are not set " + attributes;
        }
    }
}

