/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.EditChatTitle;

public final class ImmutableEditChatTitle
implements EditChatTitle {
    private final int identifier;
    private final long chatId;
    private final String title;

    private ImmutableEditChatTitle(long chatId, String title) {
        this.chatId = chatId;
        this.title = Objects.requireNonNull(title, "title");
        this.identifier = EditChatTitle.super.identifier();
    }

    private ImmutableEditChatTitle(Builder builder) {
        this.chatId = builder.chatId;
        this.title = builder.title;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditChatTitle.super.identifier();
    }

    private ImmutableEditChatTitle(int identifier, long chatId, String title) {
        this.identifier = identifier;
        this.chatId = chatId;
        this.title = title;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public String title() {
        return this.title;
    }

    public final ImmutableEditChatTitle withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditChatTitle(value, this.chatId, this.title);
    }

    public final ImmutableEditChatTitle withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableEditChatTitle(this.identifier, value, this.title);
    }

    public final ImmutableEditChatTitle withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableEditChatTitle(this.identifier, this.chatId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditChatTitle && this.equalTo(0, (ImmutableEditChatTitle)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditChatTitle another) {
        return this.identifier == another.identifier && this.chatId == another.chatId && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return "EditChatTitle{identifier=" + this.identifier + ", chatId=" + this.chatId + ", title=" + this.title + "}";
    }

    public static ImmutableEditChatTitle of(long chatId, String title) {
        return new ImmutableEditChatTitle(chatId, title);
    }

    public static ImmutableEditChatTitle copyOf(EditChatTitle instance) {
        if (instance instanceof ImmutableEditChatTitle) {
            return (ImmutableEditChatTitle)instance;
        }
        return ImmutableEditChatTitle.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long chatId;
        private String title;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EditChatTitle instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EditChatTitle) {
                instance = (EditChatTitle)object;
                this.chatId(instance.chatId());
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEditChatTitle build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditChatTitle(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build EditChatTitle, some of required attributes are not set " + attributes;
        }
    }
}

