/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.EditExportedChatInvite;

public final class ImmutableEditExportedChatInvite
implements EditExportedChatInvite {
    private final int identifier;
    private final int flags;
    private final boolean revoked;
    private final InputPeer peer;
    private final String link;
    @Nullable
    private final Integer expireDate;
    @Nullable
    private final Integer usageLimit;
    @Nullable
    private final Boolean requestNeeded;
    @Nullable
    private final String title;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEditExportedChatInvite(InputPeer peer, String link) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.link = Objects.requireNonNull(link, "link");
        this.expireDate = null;
        this.usageLimit = null;
        this.requestNeeded = null;
        this.title = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.revoked = this.initShim.revoked();
        this.initShim = null;
    }

    private ImmutableEditExportedChatInvite(Builder builder) {
        this.peer = builder.peer;
        this.link = builder.link;
        this.expireDate = builder.expireDate;
        this.usageLimit = builder.usageLimit;
        this.requestNeeded = builder.requestNeeded;
        this.title = builder.title;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.revokedIsSet()) {
            this.initShim.revoked(builder.revoked);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.revoked = this.initShim.revoked();
        this.initShim = null;
    }

    private ImmutableEditExportedChatInvite(int identifier, int flags, boolean revoked, InputPeer peer, String link, @Nullable Integer expireDate, @Nullable Integer usageLimit, @Nullable Boolean requestNeeded, @Nullable String title) {
        this.identifier = identifier;
        this.flags = flags;
        this.revoked = revoked;
        this.peer = peer;
        this.link = link;
        this.expireDate = expireDate;
        this.usageLimit = usageLimit;
        this.requestNeeded = requestNeeded;
        this.title = title;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return EditExportedChatInvite.super.identifier();
    }

    private int flagsInitialize() {
        return EditExportedChatInvite.super.flags();
    }

    private boolean revokedInitialize() {
        return EditExportedChatInvite.super.revoked();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean revoked() {
        InitShim shim = this.initShim;
        return shim != null ? shim.revoked() : this.revoked;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public String link() {
        return this.link;
    }

    @Override
    @Nullable
    public Integer expireDate() {
        return this.expireDate;
    }

    @Override
    @Nullable
    public Integer usageLimit() {
        return this.usageLimit;
    }

    @Override
    @Nullable
    public Boolean requestNeeded() {
        return this.requestNeeded;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    public final ImmutableEditExportedChatInvite withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditExportedChatInvite(value, this.flags, this.revoked, this.peer, this.link, this.expireDate, this.usageLimit, this.requestNeeded, this.title);
    }

    public final ImmutableEditExportedChatInvite withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableEditExportedChatInvite(this.identifier, value, this.revoked, this.peer, this.link, this.expireDate, this.usageLimit, this.requestNeeded, this.title);
    }

    public final ImmutableEditExportedChatInvite withRevoked(boolean value) {
        if (this.revoked == value) {
            return this;
        }
        return new ImmutableEditExportedChatInvite(this.identifier, this.flags, value, this.peer, this.link, this.expireDate, this.usageLimit, this.requestNeeded, this.title);
    }

    public final ImmutableEditExportedChatInvite withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableEditExportedChatInvite(this.identifier, this.flags, this.revoked, newValue, this.link, this.expireDate, this.usageLimit, this.requestNeeded, this.title);
    }

    public final ImmutableEditExportedChatInvite withLink(String value) {
        String newValue = Objects.requireNonNull(value, "link");
        if (this.link.equals(newValue)) {
            return this;
        }
        return new ImmutableEditExportedChatInvite(this.identifier, this.flags, this.revoked, this.peer, newValue, this.expireDate, this.usageLimit, this.requestNeeded, this.title);
    }

    public final ImmutableEditExportedChatInvite withExpireDate(@Nullable Integer value) {
        if (Objects.equals(this.expireDate, value)) {
            return this;
        }
        return new ImmutableEditExportedChatInvite(this.identifier, this.flags, this.revoked, this.peer, this.link, value, this.usageLimit, this.requestNeeded, this.title);
    }

    public final ImmutableEditExportedChatInvite withUsageLimit(@Nullable Integer value) {
        if (Objects.equals(this.usageLimit, value)) {
            return this;
        }
        return new ImmutableEditExportedChatInvite(this.identifier, this.flags, this.revoked, this.peer, this.link, this.expireDate, value, this.requestNeeded, this.title);
    }

    public final ImmutableEditExportedChatInvite withRequestNeeded(@Nullable Boolean value) {
        if (Objects.equals(this.requestNeeded, value)) {
            return this;
        }
        return new ImmutableEditExportedChatInvite(this.identifier, this.flags, this.revoked, this.peer, this.link, this.expireDate, this.usageLimit, value, this.title);
    }

    public final ImmutableEditExportedChatInvite withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableEditExportedChatInvite(this.identifier, this.flags, this.revoked, this.peer, this.link, this.expireDate, this.usageLimit, this.requestNeeded, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditExportedChatInvite && this.equalTo(0, (ImmutableEditExportedChatInvite)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditExportedChatInvite another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.revoked == another.revoked && this.peer.equals(another.peer) && this.link.equals(another.link) && Objects.equals(this.expireDate, another.expireDate) && Objects.equals(this.usageLimit, another.usageLimit) && Objects.equals(this.requestNeeded, another.requestNeeded) && Objects.equals(this.title, another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.revoked);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.link.hashCode();
        h += (h << 5) + Objects.hashCode(this.expireDate);
        h += (h << 5) + Objects.hashCode(this.usageLimit);
        h += (h << 5) + Objects.hashCode(this.requestNeeded);
        h += (h << 5) + Objects.hashCode(this.title);
        return h;
    }

    public String toString() {
        return "EditExportedChatInvite{identifier=" + this.identifier + ", flags=" + this.flags + ", revoked=" + this.revoked + ", peer=" + this.peer + ", link=" + this.link + ", expireDate=" + this.expireDate + ", usageLimit=" + this.usageLimit + ", requestNeeded=" + this.requestNeeded + ", title=" + this.title + "}";
    }

    public static ImmutableEditExportedChatInvite of(InputPeer peer, String link) {
        return new ImmutableEditExportedChatInvite(peer, link);
    }

    public static ImmutableEditExportedChatInvite copyOf(EditExportedChatInvite instance) {
        if (instance instanceof ImmutableEditExportedChatInvite) {
            return (ImmutableEditExportedChatInvite)instance;
        }
        return ImmutableEditExportedChatInvite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_LINK = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_REVOKED = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean revoked;
        private InputPeer peer;
        private String link;
        private Integer expireDate;
        private Integer usageLimit;
        private Boolean requestNeeded;
        private String title;

        private Builder() {
        }

        public final Builder from(EditExportedChatInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EditExportedChatInvite instance;
            long bits = 0L;
            if (object instanceof EditExportedChatInvite) {
                Boolean requestNeededValue;
                instance = (EditExportedChatInvite)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((requestNeededValue = instance.requestNeeded()) != null) {
                    this.requestNeeded(requestNeededValue);
                }
                this.peer(instance.peer());
                Integer usageLimitValue = instance.usageLimit();
                if (usageLimitValue != null) {
                    this.usageLimit(usageLimitValue);
                }
                this.flags(instance.flags());
                this.link(instance.link());
                Integer expireDateValue = instance.expireDate();
                if (expireDateValue != null) {
                    this.expireDate(expireDateValue);
                }
                this.revoked(instance.revoked());
                String titleValue = instance.title();
                if (titleValue != null) {
                    this.title(titleValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder revoked(boolean revoked) {
            this.revoked = revoked;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder link(String link) {
            this.link = Objects.requireNonNull(link, "link");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder expireDate(@Nullable Integer expireDate) {
            this.expireDate = expireDate;
            return this;
        }

        public final Builder usageLimit(@Nullable Integer usageLimit) {
            this.usageLimit = usageLimit;
            return this;
        }

        public final Builder requestNeeded(@Nullable Boolean requestNeeded) {
            this.requestNeeded = requestNeeded;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public ImmutableEditExportedChatInvite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditExportedChatInvite(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean revokedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("link");
            }
            return "Cannot build EditExportedChatInvite, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte revokedBuildStage = 0;
        private boolean revoked;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableEditExportedChatInvite.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableEditExportedChatInvite.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean revoked() {
            if (this.revokedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokedBuildStage == 0) {
                this.revokedBuildStage = (byte)-1;
                this.revoked = ImmutableEditExportedChatInvite.this.revokedInitialize();
                this.revokedBuildStage = 1;
            }
            return this.revoked;
        }

        void revoked(boolean revoked) {
            this.revoked = revoked;
            this.revokedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.revokedBuildStage == -1) {
                attributes.add("revoked");
            }
            return "Cannot build EditExportedChatInvite, attribute initializers form cycle " + attributes;
        }
    }
}

