/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputBotInlineMessageID;
import telegram4j.tl.InputMedia;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.EditInlineBotMessage;

public final class ImmutableEditInlineBotMessage
implements EditInlineBotMessage {
    private final int identifier;
    private final int flags;
    private final boolean noWebpage;
    private final InputBotInlineMessageID id;
    @Nullable
    private final String message;
    @Nullable
    private final InputMedia media;
    @Nullable
    private final ReplyMarkup replyMarkup;
    @Nullable
    private final List<MessageEntity> entities;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEditInlineBotMessage(InputBotInlineMessageID id) {
        this.id = Objects.requireNonNull(id, "id");
        this.message = null;
        this.media = null;
        this.replyMarkup = null;
        this.entities = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.noWebpage = this.initShim.noWebpage();
        this.initShim = null;
    }

    private ImmutableEditInlineBotMessage(Builder builder) {
        this.id = builder.id;
        this.message = builder.message;
        this.media = builder.media;
        this.replyMarkup = builder.replyMarkup;
        List<MessageEntity> list = this.entities = builder.entities == null ? null : ImmutableEditInlineBotMessage.createUnmodifiableList(true, builder.entities);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.noWebpageIsSet()) {
            this.initShim.noWebpage(builder.noWebpage);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.noWebpage = this.initShim.noWebpage();
        this.initShim = null;
    }

    private ImmutableEditInlineBotMessage(int identifier, int flags, boolean noWebpage, InputBotInlineMessageID id, @Nullable String message, @Nullable InputMedia media, @Nullable ReplyMarkup replyMarkup, @Nullable List<MessageEntity> entities) {
        this.identifier = identifier;
        this.flags = flags;
        this.noWebpage = noWebpage;
        this.id = id;
        this.message = message;
        this.media = media;
        this.replyMarkup = replyMarkup;
        this.entities = entities;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return EditInlineBotMessage.super.identifier();
    }

    private int flagsInitialize() {
        return EditInlineBotMessage.super.flags();
    }

    private boolean noWebpageInitialize() {
        return EditInlineBotMessage.super.noWebpage();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean noWebpage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noWebpage() : this.noWebpage;
    }

    @Override
    public InputBotInlineMessageID id() {
        return this.id;
    }

    @Override
    @Nullable
    public String message() {
        return this.message;
    }

    @Override
    @Nullable
    public InputMedia media() {
        return this.media;
    }

    @Override
    @Nullable
    public ReplyMarkup replyMarkup() {
        return this.replyMarkup;
    }

    @Override
    @Nullable
    public List<MessageEntity> entities() {
        return this.entities;
    }

    public final ImmutableEditInlineBotMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditInlineBotMessage(value, this.flags, this.noWebpage, this.id, this.message, this.media, this.replyMarkup, this.entities);
    }

    public final ImmutableEditInlineBotMessage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableEditInlineBotMessage(this.identifier, value, this.noWebpage, this.id, this.message, this.media, this.replyMarkup, this.entities);
    }

    public final ImmutableEditInlineBotMessage withNoWebpage(boolean value) {
        if (this.noWebpage == value) {
            return this;
        }
        return new ImmutableEditInlineBotMessage(this.identifier, this.flags, value, this.id, this.message, this.media, this.replyMarkup, this.entities);
    }

    public final ImmutableEditInlineBotMessage withId(InputBotInlineMessageID value) {
        if (this.id == value) {
            return this;
        }
        InputBotInlineMessageID newValue = Objects.requireNonNull(value, "id");
        return new ImmutableEditInlineBotMessage(this.identifier, this.flags, this.noWebpage, newValue, this.message, this.media, this.replyMarkup, this.entities);
    }

    public final ImmutableEditInlineBotMessage withMessage(@Nullable String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableEditInlineBotMessage(this.identifier, this.flags, this.noWebpage, this.id, value, this.media, this.replyMarkup, this.entities);
    }

    public final ImmutableEditInlineBotMessage withMedia(@Nullable InputMedia value) {
        if (this.media == value) {
            return this;
        }
        return new ImmutableEditInlineBotMessage(this.identifier, this.flags, this.noWebpage, this.id, this.message, value, this.replyMarkup, this.entities);
    }

    public final ImmutableEditInlineBotMessage withReplyMarkup(@Nullable ReplyMarkup value) {
        if (this.replyMarkup == value) {
            return this;
        }
        return new ImmutableEditInlineBotMessage(this.identifier, this.flags, this.noWebpage, this.id, this.message, this.media, value, this.entities);
    }

    public final ImmutableEditInlineBotMessage withEntities(MessageEntity ... elements) {
        if (elements == null) {
            return new ImmutableEditInlineBotMessage(this.identifier, this.flags, this.noWebpage, this.id, this.message, this.media, this.replyMarkup, null);
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutableEditInlineBotMessage.createUnmodifiableList(false, ImmutableEditInlineBotMessage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEditInlineBotMessage(this.identifier, this.flags, this.noWebpage, this.id, this.message, this.media, this.replyMarkup, newValue);
    }

    public final ImmutableEditInlineBotMessage withEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutableEditInlineBotMessage.createUnmodifiableList(false, ImmutableEditInlineBotMessage.createSafeList(elements, true, false));
        return new ImmutableEditInlineBotMessage(this.identifier, this.flags, this.noWebpage, this.id, this.message, this.media, this.replyMarkup, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditInlineBotMessage && this.equalTo(0, (ImmutableEditInlineBotMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditInlineBotMessage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.noWebpage == another.noWebpage && this.id.equals(another.id) && Objects.equals(this.message, another.message) && Objects.equals(this.media, another.media) && Objects.equals(this.replyMarkup, another.replyMarkup) && Objects.equals(this.entities, another.entities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.noWebpage);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.media);
        h += (h << 5) + Objects.hashCode(this.replyMarkup);
        h += (h << 5) + Objects.hashCode(this.entities);
        return h;
    }

    public String toString() {
        return "EditInlineBotMessage{identifier=" + this.identifier + ", flags=" + this.flags + ", noWebpage=" + this.noWebpage + ", id=" + this.id + ", message=" + this.message + ", media=" + this.media + ", replyMarkup=" + this.replyMarkup + ", entities=" + this.entities + "}";
    }

    public static ImmutableEditInlineBotMessage of(InputBotInlineMessageID id) {
        return new ImmutableEditInlineBotMessage(id);
    }

    public static ImmutableEditInlineBotMessage copyOf(EditInlineBotMessage instance) {
        if (instance instanceof ImmutableEditInlineBotMessage) {
            return (ImmutableEditInlineBotMessage)instance;
        }
        return ImmutableEditInlineBotMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_NO_WEBPAGE = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean noWebpage;
        private InputBotInlineMessageID id;
        private String message;
        private InputMedia media;
        private ReplyMarkup replyMarkup;
        private List<MessageEntity> entities = null;

        private Builder() {
        }

        public final Builder from(EditInlineBotMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EditInlineBotMessage instance;
            long bits = 0L;
            if (object instanceof EditInlineBotMessage) {
                String messageValue;
                ReplyMarkup replyMarkupValue;
                List<MessageEntity> entitiesValue;
                instance = (EditInlineBotMessage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((entitiesValue = instance.entities()) != null) {
                    this.addAllEntities(entitiesValue);
                }
                if ((replyMarkupValue = instance.replyMarkup()) != null) {
                    this.replyMarkup(replyMarkupValue);
                }
                this.flags(instance.flags());
                this.noWebpage(instance.noWebpage());
                this.id(instance.id());
                InputMedia mediaValue = instance.media();
                if (mediaValue != null) {
                    this.media(mediaValue);
                }
                if ((messageValue = instance.message()) != null) {
                    this.message(messageValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder noWebpage(boolean noWebpage) {
            this.noWebpage = noWebpage;
            this.optBits |= 4L;
            return this;
        }

        public final Builder id(InputBotInlineMessageID id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        public final Builder media(@Nullable InputMedia media) {
            this.media = media;
            return this;
        }

        public final Builder replyMarkup(@Nullable ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.entities = null;
                return this;
            }
            this.entities = new ArrayList<MessageEntity>();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "entities element");
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public ImmutableEditInlineBotMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditInlineBotMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean noWebpageIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build EditInlineBotMessage, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte noWebpageBuildStage = 0;
        private boolean noWebpage;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableEditInlineBotMessage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableEditInlineBotMessage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean noWebpage() {
            if (this.noWebpageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noWebpageBuildStage == 0) {
                this.noWebpageBuildStage = (byte)-1;
                this.noWebpage = ImmutableEditInlineBotMessage.this.noWebpageInitialize();
                this.noWebpageBuildStage = 1;
            }
            return this.noWebpage;
        }

        void noWebpage(boolean noWebpage) {
            this.noWebpage = noWebpage;
            this.noWebpageBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.noWebpageBuildStage == -1) {
                attributes.add("noWebpage");
            }
            return "Cannot build EditInlineBotMessage, attribute initializers form cycle " + attributes;
        }
    }
}

