/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputPeer;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.EditMessage;

public final class ImmutableEditMessage
implements EditMessage {
    private final int identifier;
    private final int flags;
    private final boolean noWebpage;
    private final InputPeer peer;
    private final int id;
    @Nullable
    private final String message;
    @Nullable
    private final InputMedia media;
    @Nullable
    private final ReplyMarkup replyMarkup;
    @Nullable
    private final List<MessageEntity> entities;
    @Nullable
    private final Integer scheduleDate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEditMessage(InputPeer peer, int id) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.id = id;
        this.message = null;
        this.media = null;
        this.replyMarkup = null;
        this.entities = null;
        this.scheduleDate = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.noWebpage = this.initShim.noWebpage();
        this.initShim = null;
    }

    private ImmutableEditMessage(Builder builder) {
        this.peer = builder.peer;
        this.id = builder.id;
        this.message = builder.message;
        this.media = builder.media;
        this.replyMarkup = builder.replyMarkup;
        this.entities = builder.entities == null ? null : ImmutableEditMessage.createUnmodifiableList(true, builder.entities);
        this.scheduleDate = builder.scheduleDate;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.noWebpageIsSet()) {
            this.initShim.noWebpage(builder.noWebpage);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.noWebpage = this.initShim.noWebpage();
        this.initShim = null;
    }

    private ImmutableEditMessage(int identifier, int flags, boolean noWebpage, InputPeer peer, int id, @Nullable String message, @Nullable InputMedia media, @Nullable ReplyMarkup replyMarkup, @Nullable List<MessageEntity> entities, @Nullable Integer scheduleDate) {
        this.identifier = identifier;
        this.flags = flags;
        this.noWebpage = noWebpage;
        this.peer = peer;
        this.id = id;
        this.message = message;
        this.media = media;
        this.replyMarkup = replyMarkup;
        this.entities = entities;
        this.scheduleDate = scheduleDate;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return EditMessage.super.identifier();
    }

    private int flagsInitialize() {
        return EditMessage.super.flags();
    }

    private boolean noWebpageInitialize() {
        return EditMessage.super.noWebpage();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean noWebpage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noWebpage() : this.noWebpage;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    @Nullable
    public String message() {
        return this.message;
    }

    @Override
    @Nullable
    public InputMedia media() {
        return this.media;
    }

    @Override
    @Nullable
    public ReplyMarkup replyMarkup() {
        return this.replyMarkup;
    }

    @Override
    @Nullable
    public List<MessageEntity> entities() {
        return this.entities;
    }

    @Override
    @Nullable
    public Integer scheduleDate() {
        return this.scheduleDate;
    }

    public final ImmutableEditMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditMessage(value, this.flags, this.noWebpage, this.peer, this.id, this.message, this.media, this.replyMarkup, this.entities, this.scheduleDate);
    }

    public final ImmutableEditMessage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableEditMessage(this.identifier, value, this.noWebpage, this.peer, this.id, this.message, this.media, this.replyMarkup, this.entities, this.scheduleDate);
    }

    public final ImmutableEditMessage withNoWebpage(boolean value) {
        if (this.noWebpage == value) {
            return this;
        }
        return new ImmutableEditMessage(this.identifier, this.flags, value, this.peer, this.id, this.message, this.media, this.replyMarkup, this.entities, this.scheduleDate);
    }

    public final ImmutableEditMessage withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableEditMessage(this.identifier, this.flags, this.noWebpage, newValue, this.id, this.message, this.media, this.replyMarkup, this.entities, this.scheduleDate);
    }

    public final ImmutableEditMessage withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableEditMessage(this.identifier, this.flags, this.noWebpage, this.peer, value, this.message, this.media, this.replyMarkup, this.entities, this.scheduleDate);
    }

    public final ImmutableEditMessage withMessage(@Nullable String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableEditMessage(this.identifier, this.flags, this.noWebpage, this.peer, this.id, value, this.media, this.replyMarkup, this.entities, this.scheduleDate);
    }

    public final ImmutableEditMessage withMedia(@Nullable InputMedia value) {
        if (this.media == value) {
            return this;
        }
        return new ImmutableEditMessage(this.identifier, this.flags, this.noWebpage, this.peer, this.id, this.message, value, this.replyMarkup, this.entities, this.scheduleDate);
    }

    public final ImmutableEditMessage withReplyMarkup(@Nullable ReplyMarkup value) {
        if (this.replyMarkup == value) {
            return this;
        }
        return new ImmutableEditMessage(this.identifier, this.flags, this.noWebpage, this.peer, this.id, this.message, this.media, value, this.entities, this.scheduleDate);
    }

    public final ImmutableEditMessage withEntities(MessageEntity ... elements) {
        if (elements == null) {
            return new ImmutableEditMessage(this.identifier, this.flags, this.noWebpage, this.peer, this.id, this.message, this.media, this.replyMarkup, null, this.scheduleDate);
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutableEditMessage.createUnmodifiableList(false, ImmutableEditMessage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEditMessage(this.identifier, this.flags, this.noWebpage, this.peer, this.id, this.message, this.media, this.replyMarkup, newValue, this.scheduleDate);
    }

    public final ImmutableEditMessage withEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutableEditMessage.createUnmodifiableList(false, ImmutableEditMessage.createSafeList(elements, true, false));
        return new ImmutableEditMessage(this.identifier, this.flags, this.noWebpage, this.peer, this.id, this.message, this.media, this.replyMarkup, newValue, this.scheduleDate);
    }

    public final ImmutableEditMessage withScheduleDate(@Nullable Integer value) {
        if (Objects.equals(this.scheduleDate, value)) {
            return this;
        }
        return new ImmutableEditMessage(this.identifier, this.flags, this.noWebpage, this.peer, this.id, this.message, this.media, this.replyMarkup, this.entities, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditMessage && this.equalTo(0, (ImmutableEditMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditMessage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.noWebpage == another.noWebpage && this.peer.equals(another.peer) && this.id == another.id && Objects.equals(this.message, another.message) && Objects.equals(this.media, another.media) && Objects.equals(this.replyMarkup, another.replyMarkup) && Objects.equals(this.entities, another.entities) && Objects.equals(this.scheduleDate, another.scheduleDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.noWebpage);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.id;
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.media);
        h += (h << 5) + Objects.hashCode(this.replyMarkup);
        h += (h << 5) + Objects.hashCode(this.entities);
        h += (h << 5) + Objects.hashCode(this.scheduleDate);
        return h;
    }

    public String toString() {
        return "EditMessage{identifier=" + this.identifier + ", flags=" + this.flags + ", noWebpage=" + this.noWebpage + ", peer=" + this.peer + ", id=" + this.id + ", message=" + this.message + ", media=" + this.media + ", replyMarkup=" + this.replyMarkup + ", entities=" + this.entities + ", scheduleDate=" + this.scheduleDate + "}";
    }

    public static ImmutableEditMessage of(InputPeer peer, int id) {
        return new ImmutableEditMessage(peer, id);
    }

    public static ImmutableEditMessage copyOf(EditMessage instance) {
        if (instance instanceof ImmutableEditMessage) {
            return (ImmutableEditMessage)instance;
        }
        return ImmutableEditMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_NO_WEBPAGE = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean noWebpage;
        private InputPeer peer;
        private int id;
        private String message;
        private InputMedia media;
        private ReplyMarkup replyMarkup;
        private List<MessageEntity> entities = null;
        private Integer scheduleDate;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EditMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EditMessage) {
                String messageValue;
                List<MessageEntity> entitiesValue;
                instance = (EditMessage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((entitiesValue = instance.entities()) != null) {
                    this.addAllEntities(entitiesValue);
                }
                this.peer(instance.peer());
                ReplyMarkup replyMarkupValue = instance.replyMarkup();
                if (replyMarkupValue != null) {
                    this.replyMarkup(replyMarkupValue);
                }
                this.flags(instance.flags());
                Integer scheduleDateValue = instance.scheduleDate();
                if (scheduleDateValue != null) {
                    this.scheduleDate(scheduleDateValue);
                }
                this.noWebpage(instance.noWebpage());
                this.id(instance.id());
                InputMedia mediaValue = instance.media();
                if (mediaValue != null) {
                    this.media(mediaValue);
                }
                if ((messageValue = instance.message()) != null) {
                    this.message(messageValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder noWebpage(boolean noWebpage) {
            this.noWebpage = noWebpage;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        public final Builder media(@Nullable InputMedia media) {
            this.media = media;
            return this;
        }

        public final Builder replyMarkup(@Nullable ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.entities = null;
                return this;
            }
            this.entities = new ArrayList<MessageEntity>();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "entities element");
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public final Builder scheduleDate(@Nullable Integer scheduleDate) {
            this.scheduleDate = scheduleDate;
            return this;
        }

        public ImmutableEditMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean noWebpageIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build EditMessage, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte noWebpageBuildStage = 0;
        private boolean noWebpage;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableEditMessage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableEditMessage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean noWebpage() {
            if (this.noWebpageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noWebpageBuildStage == 0) {
                this.noWebpageBuildStage = (byte)-1;
                this.noWebpage = ImmutableEditMessage.this.noWebpageInitialize();
                this.noWebpageBuildStage = 1;
            }
            return this.noWebpage;
        }

        void noWebpage(boolean noWebpage) {
            this.noWebpage = noWebpage;
            this.noWebpageBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.noWebpageBuildStage == -1) {
                attributes.add("noWebpage");
            }
            return "Cannot build EditMessage, attribute initializers form cycle " + attributes;
        }
    }
}

