/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ExportChatInvite;

public final class ImmutableExportChatInvite
implements ExportChatInvite {
    private final int identifier;
    private final int flags;
    private final boolean legacyRevokePermanent;
    private final boolean requestNeeded;
    private final InputPeer peer;
    @Nullable
    private final Integer expireDate;
    @Nullable
    private final Integer usageLimit;
    @Nullable
    private final String title;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableExportChatInvite(InputPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.expireDate = null;
        this.usageLimit = null;
        this.title = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.legacyRevokePermanent = this.initShim.legacyRevokePermanent();
        this.requestNeeded = this.initShim.requestNeeded();
        this.initShim = null;
    }

    private ImmutableExportChatInvite(Builder builder) {
        this.peer = builder.peer;
        this.expireDate = builder.expireDate;
        this.usageLimit = builder.usageLimit;
        this.title = builder.title;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.legacyRevokePermanentIsSet()) {
            this.initShim.legacyRevokePermanent(builder.legacyRevokePermanent);
        }
        if (builder.requestNeededIsSet()) {
            this.initShim.requestNeeded(builder.requestNeeded);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.legacyRevokePermanent = this.initShim.legacyRevokePermanent();
        this.requestNeeded = this.initShim.requestNeeded();
        this.initShim = null;
    }

    private ImmutableExportChatInvite(int identifier, int flags, boolean legacyRevokePermanent, boolean requestNeeded, InputPeer peer, @Nullable Integer expireDate, @Nullable Integer usageLimit, @Nullable String title) {
        this.identifier = identifier;
        this.flags = flags;
        this.legacyRevokePermanent = legacyRevokePermanent;
        this.requestNeeded = requestNeeded;
        this.peer = peer;
        this.expireDate = expireDate;
        this.usageLimit = usageLimit;
        this.title = title;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ExportChatInvite.super.identifier();
    }

    private int flagsInitialize() {
        return ExportChatInvite.super.flags();
    }

    private boolean legacyRevokePermanentInitialize() {
        return ExportChatInvite.super.legacyRevokePermanent();
    }

    private boolean requestNeededInitialize() {
        return ExportChatInvite.super.requestNeeded();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean legacyRevokePermanent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.legacyRevokePermanent() : this.legacyRevokePermanent;
    }

    @Override
    public boolean requestNeeded() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requestNeeded() : this.requestNeeded;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    @Nullable
    public Integer expireDate() {
        return this.expireDate;
    }

    @Override
    @Nullable
    public Integer usageLimit() {
        return this.usageLimit;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    public final ImmutableExportChatInvite withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableExportChatInvite(value, this.flags, this.legacyRevokePermanent, this.requestNeeded, this.peer, this.expireDate, this.usageLimit, this.title);
    }

    public final ImmutableExportChatInvite withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableExportChatInvite(this.identifier, value, this.legacyRevokePermanent, this.requestNeeded, this.peer, this.expireDate, this.usageLimit, this.title);
    }

    public final ImmutableExportChatInvite withLegacyRevokePermanent(boolean value) {
        if (this.legacyRevokePermanent == value) {
            return this;
        }
        return new ImmutableExportChatInvite(this.identifier, this.flags, value, this.requestNeeded, this.peer, this.expireDate, this.usageLimit, this.title);
    }

    public final ImmutableExportChatInvite withRequestNeeded(boolean value) {
        if (this.requestNeeded == value) {
            return this;
        }
        return new ImmutableExportChatInvite(this.identifier, this.flags, this.legacyRevokePermanent, value, this.peer, this.expireDate, this.usageLimit, this.title);
    }

    public final ImmutableExportChatInvite withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableExportChatInvite(this.identifier, this.flags, this.legacyRevokePermanent, this.requestNeeded, newValue, this.expireDate, this.usageLimit, this.title);
    }

    public final ImmutableExportChatInvite withExpireDate(@Nullable Integer value) {
        if (Objects.equals(this.expireDate, value)) {
            return this;
        }
        return new ImmutableExportChatInvite(this.identifier, this.flags, this.legacyRevokePermanent, this.requestNeeded, this.peer, value, this.usageLimit, this.title);
    }

    public final ImmutableExportChatInvite withUsageLimit(@Nullable Integer value) {
        if (Objects.equals(this.usageLimit, value)) {
            return this;
        }
        return new ImmutableExportChatInvite(this.identifier, this.flags, this.legacyRevokePermanent, this.requestNeeded, this.peer, this.expireDate, value, this.title);
    }

    public final ImmutableExportChatInvite withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableExportChatInvite(this.identifier, this.flags, this.legacyRevokePermanent, this.requestNeeded, this.peer, this.expireDate, this.usageLimit, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExportChatInvite && this.equalTo(0, (ImmutableExportChatInvite)another);
    }

    private boolean equalTo(int synthetic, ImmutableExportChatInvite another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.legacyRevokePermanent == another.legacyRevokePermanent && this.requestNeeded == another.requestNeeded && this.peer.equals(another.peer) && Objects.equals(this.expireDate, another.expireDate) && Objects.equals(this.usageLimit, another.usageLimit) && Objects.equals(this.title, another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.legacyRevokePermanent);
        h += (h << 5) + Boolean.hashCode(this.requestNeeded);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Objects.hashCode(this.expireDate);
        h += (h << 5) + Objects.hashCode(this.usageLimit);
        h += (h << 5) + Objects.hashCode(this.title);
        return h;
    }

    public String toString() {
        return "ExportChatInvite{identifier=" + this.identifier + ", flags=" + this.flags + ", legacyRevokePermanent=" + this.legacyRevokePermanent + ", requestNeeded=" + this.requestNeeded + ", peer=" + this.peer + ", expireDate=" + this.expireDate + ", usageLimit=" + this.usageLimit + ", title=" + this.title + "}";
    }

    public static ImmutableExportChatInvite of(InputPeer peer) {
        return new ImmutableExportChatInvite(peer);
    }

    public static ImmutableExportChatInvite copyOf(ExportChatInvite instance) {
        if (instance instanceof ImmutableExportChatInvite) {
            return (ImmutableExportChatInvite)instance;
        }
        return ImmutableExportChatInvite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_LEGACY_REVOKE_PERMANENT = 4L;
        private static final long OPT_BIT_REQUEST_NEEDED = 8L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean legacyRevokePermanent;
        private boolean requestNeeded;
        private InputPeer peer;
        private Integer expireDate;
        private Integer usageLimit;
        private String title;

        private Builder() {
        }

        public final Builder from(ExportChatInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ExportChatInvite instance;
            long bits = 0L;
            if (object instanceof ExportChatInvite) {
                String titleValue;
                instance = (ExportChatInvite)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.requestNeeded(instance.requestNeeded());
                this.peer(instance.peer());
                Integer usageLimitValue = instance.usageLimit();
                if (usageLimitValue != null) {
                    this.usageLimit(usageLimitValue);
                }
                this.flags(instance.flags());
                this.legacyRevokePermanent(instance.legacyRevokePermanent());
                Integer expireDateValue = instance.expireDate();
                if (expireDateValue != null) {
                    this.expireDate(expireDateValue);
                }
                if ((titleValue = instance.title()) != null) {
                    this.title(titleValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder legacyRevokePermanent(boolean legacyRevokePermanent) {
            this.legacyRevokePermanent = legacyRevokePermanent;
            this.optBits |= 4L;
            return this;
        }

        public final Builder requestNeeded(boolean requestNeeded) {
            this.requestNeeded = requestNeeded;
            this.optBits |= 8L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder expireDate(@Nullable Integer expireDate) {
            this.expireDate = expireDate;
            return this;
        }

        public final Builder usageLimit(@Nullable Integer usageLimit) {
            this.usageLimit = usageLimit;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public ImmutableExportChatInvite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExportChatInvite(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean legacyRevokePermanentIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean requestNeededIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build ExportChatInvite, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte legacyRevokePermanentBuildStage = 0;
        private boolean legacyRevokePermanent;
        private byte requestNeededBuildStage = 0;
        private boolean requestNeeded;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableExportChatInvite.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableExportChatInvite.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean legacyRevokePermanent() {
            if (this.legacyRevokePermanentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.legacyRevokePermanentBuildStage == 0) {
                this.legacyRevokePermanentBuildStage = (byte)-1;
                this.legacyRevokePermanent = ImmutableExportChatInvite.this.legacyRevokePermanentInitialize();
                this.legacyRevokePermanentBuildStage = 1;
            }
            return this.legacyRevokePermanent;
        }

        void legacyRevokePermanent(boolean legacyRevokePermanent) {
            this.legacyRevokePermanent = legacyRevokePermanent;
            this.legacyRevokePermanentBuildStage = 1;
        }

        boolean requestNeeded() {
            if (this.requestNeededBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestNeededBuildStage == 0) {
                this.requestNeededBuildStage = (byte)-1;
                this.requestNeeded = ImmutableExportChatInvite.this.requestNeededInitialize();
                this.requestNeededBuildStage = 1;
            }
            return this.requestNeeded;
        }

        void requestNeeded(boolean requestNeeded) {
            this.requestNeeded = requestNeeded;
            this.requestNeededBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.legacyRevokePermanentBuildStage == -1) {
                attributes.add("legacyRevokePermanent");
            }
            if (this.requestNeededBuildStage == -1) {
                attributes.add("requestNeeded");
            }
            return "Cannot build ExportChatInvite, attribute initializers form cycle " + attributes;
        }
    }
}

