/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputDocument;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.FaveSticker;

public final class ImmutableFaveSticker
implements FaveSticker {
    private final int identifier;
    private final InputDocument id;
    private final boolean unfave;

    private ImmutableFaveSticker(InputDocument id, boolean unfave) {
        this.id = Objects.requireNonNull(id, "id");
        this.unfave = unfave;
        this.identifier = FaveSticker.super.identifier();
    }

    private ImmutableFaveSticker(Builder builder) {
        this.id = builder.id;
        this.unfave = builder.unfave;
        this.identifier = builder.identifierIsSet() ? builder.identifier : FaveSticker.super.identifier();
    }

    private ImmutableFaveSticker(int identifier, InputDocument id, boolean unfave) {
        this.identifier = identifier;
        this.id = id;
        this.unfave = unfave;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputDocument id() {
        return this.id;
    }

    @Override
    public boolean unfave() {
        return this.unfave;
    }

    public final ImmutableFaveSticker withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableFaveSticker(value, this.id, this.unfave);
    }

    public final ImmutableFaveSticker withId(InputDocument value) {
        if (this.id == value) {
            return this;
        }
        InputDocument newValue = Objects.requireNonNull(value, "id");
        return new ImmutableFaveSticker(this.identifier, newValue, this.unfave);
    }

    public final ImmutableFaveSticker withUnfave(boolean value) {
        if (this.unfave == value) {
            return this;
        }
        return new ImmutableFaveSticker(this.identifier, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFaveSticker && this.equalTo(0, (ImmutableFaveSticker)another);
    }

    private boolean equalTo(int synthetic, ImmutableFaveSticker another) {
        return this.identifier == another.identifier && this.id.equals(another.id) && this.unfave == another.unfave;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Boolean.hashCode(this.unfave);
        return h;
    }

    public String toString() {
        return "FaveSticker{identifier=" + this.identifier + ", id=" + this.id + ", unfave=" + this.unfave + "}";
    }

    public static ImmutableFaveSticker of(InputDocument id, boolean unfave) {
        return new ImmutableFaveSticker(id, unfave);
    }

    public static ImmutableFaveSticker copyOf(FaveSticker instance) {
        if (instance instanceof ImmutableFaveSticker) {
            return (ImmutableFaveSticker)instance;
        }
        return ImmutableFaveSticker.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_UNFAVE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputDocument id;
        private boolean unfave;

        private Builder() {
        }

        public final Builder from(FaveSticker instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            FaveSticker instance;
            long bits = 0L;
            if (object instanceof FaveSticker) {
                instance = (FaveSticker)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.unfave(instance.unfave());
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(InputDocument id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder unfave(boolean unfave) {
            this.unfave = unfave;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableFaveSticker build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFaveSticker(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("unfave");
            }
            return "Cannot build FaveSticker, some of required attributes are not set " + attributes;
        }
    }
}

