/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.ForwardMessages;

public final class ImmutableForwardMessages
implements ForwardMessages {
    private final int identifier;
    private final int flags;
    private final boolean silent;
    private final boolean background;
    private final boolean withMyScore;
    private final boolean dropAuthor;
    private final boolean dropMediaCaptions;
    private final boolean noforwards;
    private final InputPeer fromPeer;
    private final List<Integer> id;
    private final List<Long> randomId;
    private final InputPeer toPeer;
    @Nullable
    private final Integer scheduleDate;
    @Nullable
    private final InputPeer sendAs;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableForwardMessages(InputPeer fromPeer, InputPeer toPeer) {
        this.fromPeer = Objects.requireNonNull(fromPeer, "fromPeer");
        this.toPeer = Objects.requireNonNull(toPeer, "toPeer");
        this.id = Collections.emptyList();
        this.randomId = Collections.emptyList();
        this.scheduleDate = null;
        this.sendAs = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.silent = this.initShim.silent();
        this.background = this.initShim.background();
        this.withMyScore = this.initShim.withMyScore();
        this.dropAuthor = this.initShim.dropAuthor();
        this.dropMediaCaptions = this.initShim.dropMediaCaptions();
        this.noforwards = this.initShim.noforwards();
        this.initShim = null;
    }

    private ImmutableForwardMessages(Builder builder) {
        this.fromPeer = builder.fromPeer;
        this.id = ImmutableForwardMessages.createUnmodifiableList(true, builder.id);
        this.randomId = ImmutableForwardMessages.createUnmodifiableList(true, builder.randomId);
        this.toPeer = builder.toPeer;
        this.scheduleDate = builder.scheduleDate;
        this.sendAs = builder.sendAs;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.silentIsSet()) {
            this.initShim.silent(builder.silent);
        }
        if (builder.backgroundIsSet()) {
            this.initShim.background(builder.background);
        }
        if (builder.withMyScoreIsSet()) {
            this.initShim.withMyScore(builder.withMyScore);
        }
        if (builder.dropAuthorIsSet()) {
            this.initShim.dropAuthor(builder.dropAuthor);
        }
        if (builder.dropMediaCaptionsIsSet()) {
            this.initShim.dropMediaCaptions(builder.dropMediaCaptions);
        }
        if (builder.noforwardsIsSet()) {
            this.initShim.noforwards(builder.noforwards);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.silent = this.initShim.silent();
        this.background = this.initShim.background();
        this.withMyScore = this.initShim.withMyScore();
        this.dropAuthor = this.initShim.dropAuthor();
        this.dropMediaCaptions = this.initShim.dropMediaCaptions();
        this.noforwards = this.initShim.noforwards();
        this.initShim = null;
    }

    private ImmutableForwardMessages(int identifier, int flags, boolean silent, boolean background, boolean withMyScore, boolean dropAuthor, boolean dropMediaCaptions, boolean noforwards, InputPeer fromPeer, List<Integer> id, List<Long> randomId, InputPeer toPeer, @Nullable Integer scheduleDate, @Nullable InputPeer sendAs) {
        this.identifier = identifier;
        this.flags = flags;
        this.silent = silent;
        this.background = background;
        this.withMyScore = withMyScore;
        this.dropAuthor = dropAuthor;
        this.dropMediaCaptions = dropMediaCaptions;
        this.noforwards = noforwards;
        this.fromPeer = fromPeer;
        this.id = id;
        this.randomId = randomId;
        this.toPeer = toPeer;
        this.scheduleDate = scheduleDate;
        this.sendAs = sendAs;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ForwardMessages.super.identifier();
    }

    private int flagsInitialize() {
        return ForwardMessages.super.flags();
    }

    private boolean silentInitialize() {
        return ForwardMessages.super.silent();
    }

    private boolean backgroundInitialize() {
        return ForwardMessages.super.background();
    }

    private boolean withMyScoreInitialize() {
        return ForwardMessages.super.withMyScore();
    }

    private boolean dropAuthorInitialize() {
        return ForwardMessages.super.dropAuthor();
    }

    private boolean dropMediaCaptionsInitialize() {
        return ForwardMessages.super.dropMediaCaptions();
    }

    private boolean noforwardsInitialize() {
        return ForwardMessages.super.noforwards();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean silent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.silent() : this.silent;
    }

    @Override
    public boolean background() {
        InitShim shim = this.initShim;
        return shim != null ? shim.background() : this.background;
    }

    @Override
    public boolean withMyScore() {
        InitShim shim = this.initShim;
        return shim != null ? shim.withMyScore() : this.withMyScore;
    }

    @Override
    public boolean dropAuthor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dropAuthor() : this.dropAuthor;
    }

    @Override
    public boolean dropMediaCaptions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dropMediaCaptions() : this.dropMediaCaptions;
    }

    @Override
    public boolean noforwards() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noforwards() : this.noforwards;
    }

    @Override
    public InputPeer fromPeer() {
        return this.fromPeer;
    }

    @Override
    public List<Integer> id() {
        return this.id;
    }

    @Override
    public List<Long> randomId() {
        return this.randomId;
    }

    @Override
    public InputPeer toPeer() {
        return this.toPeer;
    }

    @Override
    @Nullable
    public Integer scheduleDate() {
        return this.scheduleDate;
    }

    @Override
    @Nullable
    public InputPeer sendAs() {
        return this.sendAs;
    }

    public final ImmutableForwardMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableForwardMessages(value, this.flags, this.silent, this.background, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, this.noforwards, this.fromPeer, this.id, this.randomId, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableForwardMessages(this.identifier, value, this.silent, this.background, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, this.noforwards, this.fromPeer, this.id, this.randomId, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withSilent(boolean value) {
        if (this.silent == value) {
            return this;
        }
        return new ImmutableForwardMessages(this.identifier, this.flags, value, this.background, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, this.noforwards, this.fromPeer, this.id, this.randomId, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withBackground(boolean value) {
        if (this.background == value) {
            return this;
        }
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, value, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, this.noforwards, this.fromPeer, this.id, this.randomId, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withWithMyScore(boolean value) {
        if (this.withMyScore == value) {
            return this;
        }
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, this.background, value, this.dropAuthor, this.dropMediaCaptions, this.noforwards, this.fromPeer, this.id, this.randomId, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withDropAuthor(boolean value) {
        if (this.dropAuthor == value) {
            return this;
        }
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, this.background, this.withMyScore, value, this.dropMediaCaptions, this.noforwards, this.fromPeer, this.id, this.randomId, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withDropMediaCaptions(boolean value) {
        if (this.dropMediaCaptions == value) {
            return this;
        }
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, this.background, this.withMyScore, this.dropAuthor, value, this.noforwards, this.fromPeer, this.id, this.randomId, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withNoforwards(boolean value) {
        if (this.noforwards == value) {
            return this;
        }
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, this.background, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, value, this.fromPeer, this.id, this.randomId, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withFromPeer(InputPeer value) {
        if (this.fromPeer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "fromPeer");
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, this.background, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, this.noforwards, newValue, this.id, this.randomId, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withId(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableForwardMessages.createUnmodifiableList(false, wrappedList);
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, this.background, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, this.noforwards, this.fromPeer, newValue, this.randomId, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withId(Iterable<Integer> elements) {
        if (this.id == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableForwardMessages.createUnmodifiableList(false, ImmutableForwardMessages.createSafeList(elements, true, false));
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, this.background, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, this.noforwards, this.fromPeer, newValue, this.randomId, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withRandomId(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableForwardMessages.createUnmodifiableList(false, wrappedList);
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, this.background, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, this.noforwards, this.fromPeer, this.id, newValue, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withRandomId(Iterable<Long> elements) {
        if (this.randomId == elements) {
            return this;
        }
        List<Long> newValue = ImmutableForwardMessages.createUnmodifiableList(false, ImmutableForwardMessages.createSafeList(elements, true, false));
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, this.background, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, this.noforwards, this.fromPeer, this.id, newValue, this.toPeer, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withToPeer(InputPeer value) {
        if (this.toPeer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "toPeer");
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, this.background, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, this.noforwards, this.fromPeer, this.id, this.randomId, newValue, this.scheduleDate, this.sendAs);
    }

    public final ImmutableForwardMessages withScheduleDate(@Nullable Integer value) {
        if (Objects.equals(this.scheduleDate, value)) {
            return this;
        }
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, this.background, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, this.noforwards, this.fromPeer, this.id, this.randomId, this.toPeer, value, this.sendAs);
    }

    public final ImmutableForwardMessages withSendAs(@Nullable InputPeer value) {
        if (this.sendAs == value) {
            return this;
        }
        return new ImmutableForwardMessages(this.identifier, this.flags, this.silent, this.background, this.withMyScore, this.dropAuthor, this.dropMediaCaptions, this.noforwards, this.fromPeer, this.id, this.randomId, this.toPeer, this.scheduleDate, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableForwardMessages && this.equalTo(0, (ImmutableForwardMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableForwardMessages another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.silent == another.silent && this.background == another.background && this.withMyScore == another.withMyScore && this.dropAuthor == another.dropAuthor && this.dropMediaCaptions == another.dropMediaCaptions && this.noforwards == another.noforwards && this.fromPeer.equals(another.fromPeer) && this.id.equals(another.id) && this.randomId.equals(another.randomId) && this.toPeer.equals(another.toPeer) && Objects.equals(this.scheduleDate, another.scheduleDate) && Objects.equals(this.sendAs, another.sendAs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.silent);
        h += (h << 5) + Boolean.hashCode(this.background);
        h += (h << 5) + Boolean.hashCode(this.withMyScore);
        h += (h << 5) + Boolean.hashCode(this.dropAuthor);
        h += (h << 5) + Boolean.hashCode(this.dropMediaCaptions);
        h += (h << 5) + Boolean.hashCode(this.noforwards);
        h += (h << 5) + this.fromPeer.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.randomId.hashCode();
        h += (h << 5) + this.toPeer.hashCode();
        h += (h << 5) + Objects.hashCode(this.scheduleDate);
        h += (h << 5) + Objects.hashCode(this.sendAs);
        return h;
    }

    public String toString() {
        return "ForwardMessages{identifier=" + this.identifier + ", flags=" + this.flags + ", silent=" + this.silent + ", background=" + this.background + ", withMyScore=" + this.withMyScore + ", dropAuthor=" + this.dropAuthor + ", dropMediaCaptions=" + this.dropMediaCaptions + ", noforwards=" + this.noforwards + ", fromPeer=" + this.fromPeer + ", id=" + this.id + ", randomId=" + this.randomId + ", toPeer=" + this.toPeer + ", scheduleDate=" + this.scheduleDate + ", sendAs=" + this.sendAs + "}";
    }

    public static ImmutableForwardMessages of(InputPeer fromPeer, InputPeer toPeer) {
        return new ImmutableForwardMessages(fromPeer, toPeer);
    }

    public static ImmutableForwardMessages copyOf(ForwardMessages instance) {
        if (instance instanceof ImmutableForwardMessages) {
            return (ImmutableForwardMessages)instance;
        }
        return ImmutableForwardMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_FROM_PEER = 1L;
        private static final long INIT_BIT_TO_PEER = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SILENT = 4L;
        private static final long OPT_BIT_BACKGROUND = 8L;
        private static final long OPT_BIT_WITH_MY_SCORE = 16L;
        private static final long OPT_BIT_DROP_AUTHOR = 32L;
        private static final long OPT_BIT_DROP_MEDIA_CAPTIONS = 64L;
        private static final long OPT_BIT_NOFORWARDS = 128L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean silent;
        private boolean background;
        private boolean withMyScore;
        private boolean dropAuthor;
        private boolean dropMediaCaptions;
        private boolean noforwards;
        private InputPeer fromPeer;
        private List<Integer> id = new ArrayList<Integer>();
        private List<Long> randomId = new ArrayList<Long>();
        private InputPeer toPeer;
        private Integer scheduleDate;
        private InputPeer sendAs;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ForwardMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ForwardMessages) {
                instance = (ForwardMessages)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.silent(instance.silent());
                this.dropAuthor(instance.dropAuthor());
                this.fromPeer(instance.fromPeer());
                this.withMyScore(instance.withMyScore());
                this.noforwards(instance.noforwards());
                this.flags(instance.flags());
                this.toPeer(instance.toPeer());
                this.addAllRandomId(instance.randomId());
                this.background(instance.background());
                Integer scheduleDateValue = instance.scheduleDate();
                if (scheduleDateValue != null) {
                    this.scheduleDate(scheduleDateValue);
                }
                this.dropMediaCaptions(instance.dropMediaCaptions());
                InputPeer sendAsValue = instance.sendAs();
                if (sendAsValue != null) {
                    this.sendAs(sendAsValue);
                }
                this.addAllId(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder silent(boolean silent) {
            this.silent = silent;
            this.optBits |= 4L;
            return this;
        }

        public final Builder background(boolean background) {
            this.background = background;
            this.optBits |= 8L;
            return this;
        }

        public final Builder withMyScore(boolean withMyScore) {
            this.withMyScore = withMyScore;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder dropAuthor(boolean dropAuthor) {
            this.dropAuthor = dropAuthor;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder dropMediaCaptions(boolean dropMediaCaptions) {
            this.dropMediaCaptions = dropMediaCaptions;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder noforwards(boolean noforwards) {
            this.noforwards = noforwards;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder fromPeer(InputPeer fromPeer) {
            this.fromPeer = Objects.requireNonNull(fromPeer, "fromPeer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addId(int element) {
            this.id.add(element);
            return this;
        }

        public final Builder addId(int ... elements) {
            for (int element : elements) {
                this.id.add(element);
            }
            return this;
        }

        public final Builder id(Iterable<Integer> elements) {
            this.id.clear();
            return this.addAllId(elements);
        }

        public final Builder addAllId(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.id.add(Objects.requireNonNull(element, "id element"));
            }
            return this;
        }

        public final Builder addRandomId(long element) {
            this.randomId.add(element);
            return this;
        }

        public final Builder addRandomId(long ... elements) {
            for (long element : elements) {
                this.randomId.add(element);
            }
            return this;
        }

        public final Builder randomId(Iterable<Long> elements) {
            this.randomId.clear();
            return this.addAllRandomId(elements);
        }

        public final Builder addAllRandomId(Iterable<Long> elements) {
            for (Long element : elements) {
                this.randomId.add(Objects.requireNonNull(element, "randomId element"));
            }
            return this;
        }

        public final Builder toPeer(InputPeer toPeer) {
            this.toPeer = Objects.requireNonNull(toPeer, "toPeer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder scheduleDate(@Nullable Integer scheduleDate) {
            this.scheduleDate = scheduleDate;
            return this;
        }

        public final Builder sendAs(@Nullable InputPeer sendAs) {
            this.sendAs = sendAs;
            return this;
        }

        public ImmutableForwardMessages build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableForwardMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean silentIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean backgroundIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean withMyScoreIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean dropAuthorIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean dropMediaCaptionsIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean noforwardsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fromPeer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("toPeer");
            }
            return "Cannot build ForwardMessages, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte silentBuildStage = 0;
        private boolean silent;
        private byte backgroundBuildStage = 0;
        private boolean background;
        private byte withMyScoreBuildStage = 0;
        private boolean withMyScore;
        private byte dropAuthorBuildStage = 0;
        private boolean dropAuthor;
        private byte dropMediaCaptionsBuildStage = 0;
        private boolean dropMediaCaptions;
        private byte noforwardsBuildStage = 0;
        private boolean noforwards;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableForwardMessages.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableForwardMessages.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean silent() {
            if (this.silentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.silentBuildStage == 0) {
                this.silentBuildStage = (byte)-1;
                this.silent = ImmutableForwardMessages.this.silentInitialize();
                this.silentBuildStage = 1;
            }
            return this.silent;
        }

        void silent(boolean silent) {
            this.silent = silent;
            this.silentBuildStage = 1;
        }

        boolean background() {
            if (this.backgroundBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.backgroundBuildStage == 0) {
                this.backgroundBuildStage = (byte)-1;
                this.background = ImmutableForwardMessages.this.backgroundInitialize();
                this.backgroundBuildStage = 1;
            }
            return this.background;
        }

        void background(boolean background) {
            this.background = background;
            this.backgroundBuildStage = 1;
        }

        boolean withMyScore() {
            if (this.withMyScoreBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.withMyScoreBuildStage == 0) {
                this.withMyScoreBuildStage = (byte)-1;
                this.withMyScore = ImmutableForwardMessages.this.withMyScoreInitialize();
                this.withMyScoreBuildStage = 1;
            }
            return this.withMyScore;
        }

        void withMyScore(boolean withMyScore) {
            this.withMyScore = withMyScore;
            this.withMyScoreBuildStage = 1;
        }

        boolean dropAuthor() {
            if (this.dropAuthorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dropAuthorBuildStage == 0) {
                this.dropAuthorBuildStage = (byte)-1;
                this.dropAuthor = ImmutableForwardMessages.this.dropAuthorInitialize();
                this.dropAuthorBuildStage = 1;
            }
            return this.dropAuthor;
        }

        void dropAuthor(boolean dropAuthor) {
            this.dropAuthor = dropAuthor;
            this.dropAuthorBuildStage = 1;
        }

        boolean dropMediaCaptions() {
            if (this.dropMediaCaptionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dropMediaCaptionsBuildStage == 0) {
                this.dropMediaCaptionsBuildStage = (byte)-1;
                this.dropMediaCaptions = ImmutableForwardMessages.this.dropMediaCaptionsInitialize();
                this.dropMediaCaptionsBuildStage = 1;
            }
            return this.dropMediaCaptions;
        }

        void dropMediaCaptions(boolean dropMediaCaptions) {
            this.dropMediaCaptions = dropMediaCaptions;
            this.dropMediaCaptionsBuildStage = 1;
        }

        boolean noforwards() {
            if (this.noforwardsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noforwardsBuildStage == 0) {
                this.noforwardsBuildStage = (byte)-1;
                this.noforwards = ImmutableForwardMessages.this.noforwardsInitialize();
                this.noforwardsBuildStage = 1;
            }
            return this.noforwards;
        }

        void noforwards(boolean noforwards) {
            this.noforwards = noforwards;
            this.noforwardsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.silentBuildStage == -1) {
                attributes.add("silent");
            }
            if (this.backgroundBuildStage == -1) {
                attributes.add("background");
            }
            if (this.withMyScoreBuildStage == -1) {
                attributes.add("withMyScore");
            }
            if (this.dropAuthorBuildStage == -1) {
                attributes.add("dropAuthor");
            }
            if (this.dropMediaCaptionsBuildStage == -1) {
                attributes.add("dropMediaCaptions");
            }
            if (this.noforwardsBuildStage == -1) {
                attributes.add("noforwards");
            }
            return "Cannot build ForwardMessages, attribute initializers form cycle " + attributes;
        }
    }
}

