/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetAllChats;

public final class ImmutableGetAllChats
implements GetAllChats {
    private final int identifier;
    private final List<Long> exceptIds;

    private ImmutableGetAllChats(Builder builder) {
        this.exceptIds = ImmutableGetAllChats.createUnmodifiableList(true, builder.exceptIds);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetAllChats.super.identifier();
    }

    private ImmutableGetAllChats(int identifier, List<Long> exceptIds) {
        this.identifier = identifier;
        this.exceptIds = exceptIds;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Long> exceptIds() {
        return this.exceptIds;
    }

    public final ImmutableGetAllChats withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetAllChats(value, this.exceptIds);
    }

    public final ImmutableGetAllChats withExceptIds(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableGetAllChats.createUnmodifiableList(false, wrappedList);
        return new ImmutableGetAllChats(this.identifier, newValue);
    }

    public final ImmutableGetAllChats withExceptIds(Iterable<Long> elements) {
        if (this.exceptIds == elements) {
            return this;
        }
        List<Long> newValue = ImmutableGetAllChats.createUnmodifiableList(false, ImmutableGetAllChats.createSafeList(elements, true, false));
        return new ImmutableGetAllChats(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetAllChats && this.equalTo(0, (ImmutableGetAllChats)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetAllChats another) {
        return this.identifier == another.identifier && this.exceptIds.equals(another.exceptIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.exceptIds.hashCode();
        return h;
    }

    public String toString() {
        return "GetAllChats{identifier=" + this.identifier + ", exceptIds=" + this.exceptIds + "}";
    }

    public static ImmutableGetAllChats copyOf(GetAllChats instance) {
        if (instance instanceof ImmutableGetAllChats) {
            return (ImmutableGetAllChats)instance;
        }
        return ImmutableGetAllChats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Long> exceptIds = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(GetAllChats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetAllChats instance;
            long bits = 0L;
            if (object instanceof GetAllChats) {
                instance = (GetAllChats)object;
                this.addAllExceptIds(instance.exceptIds());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addExceptId(long element) {
            this.exceptIds.add(element);
            return this;
        }

        public final Builder addExceptIds(long ... elements) {
            for (long element : elements) {
                this.exceptIds.add(element);
            }
            return this;
        }

        public final Builder exceptIds(Iterable<Long> elements) {
            this.exceptIds.clear();
            return this.addAllExceptIds(elements);
        }

        public final Builder addAllExceptIds(Iterable<Long> elements) {
            for (Long element : elements) {
                this.exceptIds.add(Objects.requireNonNull(element, "exceptIds element"));
            }
            return this;
        }

        public ImmutableGetAllChats build() {
            return new ImmutableGetAllChats(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

