/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.GetArchivedStickers;

public final class ImmutableGetArchivedStickers
implements GetArchivedStickers {
    private final int identifier;
    private final int flags;
    private final boolean masks;
    private final boolean emojis;
    private final long offsetId;
    private final int limit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetArchivedStickers(long offsetId, int limit) {
        this.offsetId = offsetId;
        this.limit = limit;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.masks = this.initShim.masks();
        this.emojis = this.initShim.emojis();
        this.initShim = null;
    }

    private ImmutableGetArchivedStickers(Builder builder) {
        this.offsetId = builder.offsetId;
        this.limit = builder.limit;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.masksIsSet()) {
            this.initShim.masks(builder.masks);
        }
        if (builder.emojisIsSet()) {
            this.initShim.emojis(builder.emojis);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.masks = this.initShim.masks();
        this.emojis = this.initShim.emojis();
        this.initShim = null;
    }

    private ImmutableGetArchivedStickers(int identifier, int flags, boolean masks, boolean emojis, long offsetId, int limit) {
        this.identifier = identifier;
        this.flags = flags;
        this.masks = masks;
        this.emojis = emojis;
        this.offsetId = offsetId;
        this.limit = limit;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetArchivedStickers.super.identifier();
    }

    private int flagsInitialize() {
        return GetArchivedStickers.super.flags();
    }

    private boolean masksInitialize() {
        return GetArchivedStickers.super.masks();
    }

    private boolean emojisInitialize() {
        return GetArchivedStickers.super.emojis();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean masks() {
        InitShim shim = this.initShim;
        return shim != null ? shim.masks() : this.masks;
    }

    @Override
    public boolean emojis() {
        InitShim shim = this.initShim;
        return shim != null ? shim.emojis() : this.emojis;
    }

    @Override
    public long offsetId() {
        return this.offsetId;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetArchivedStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetArchivedStickers(value, this.flags, this.masks, this.emojis, this.offsetId, this.limit);
    }

    public final ImmutableGetArchivedStickers withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetArchivedStickers(this.identifier, value, this.masks, this.emojis, this.offsetId, this.limit);
    }

    public final ImmutableGetArchivedStickers withMasks(boolean value) {
        if (this.masks == value) {
            return this;
        }
        return new ImmutableGetArchivedStickers(this.identifier, this.flags, value, this.emojis, this.offsetId, this.limit);
    }

    public final ImmutableGetArchivedStickers withEmojis(boolean value) {
        if (this.emojis == value) {
            return this;
        }
        return new ImmutableGetArchivedStickers(this.identifier, this.flags, this.masks, value, this.offsetId, this.limit);
    }

    public final ImmutableGetArchivedStickers withOffsetId(long value) {
        if (this.offsetId == value) {
            return this;
        }
        return new ImmutableGetArchivedStickers(this.identifier, this.flags, this.masks, this.emojis, value, this.limit);
    }

    public final ImmutableGetArchivedStickers withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetArchivedStickers(this.identifier, this.flags, this.masks, this.emojis, this.offsetId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetArchivedStickers && this.equalTo(0, (ImmutableGetArchivedStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetArchivedStickers another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.masks == another.masks && this.emojis == another.emojis && this.offsetId == another.offsetId && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.masks);
        h += (h << 5) + Boolean.hashCode(this.emojis);
        h += (h << 5) + Long.hashCode(this.offsetId);
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetArchivedStickers{identifier=" + this.identifier + ", flags=" + this.flags + ", masks=" + this.masks + ", emojis=" + this.emojis + ", offsetId=" + this.offsetId + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetArchivedStickers of(long offsetId, int limit) {
        return new ImmutableGetArchivedStickers(offsetId, limit);
    }

    public static ImmutableGetArchivedStickers copyOf(GetArchivedStickers instance) {
        if (instance instanceof ImmutableGetArchivedStickers) {
            return (ImmutableGetArchivedStickers)instance;
        }
        return ImmutableGetArchivedStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET_ID = 1L;
        private static final long INIT_BIT_LIMIT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_MASKS = 4L;
        private static final long OPT_BIT_EMOJIS = 8L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean masks;
        private boolean emojis;
        private long offsetId;
        private int limit;

        private Builder() {
        }

        public final Builder from(GetArchivedStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetArchivedStickers instance;
            long bits = 0L;
            if (object instanceof GetArchivedStickers) {
                instance = (GetArchivedStickers)object;
                this.emojis(instance.emojis());
                this.flags(instance.flags());
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.masks(instance.masks());
                this.offsetId(instance.offsetId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder masks(boolean masks) {
            this.masks = masks;
            this.optBits |= 4L;
            return this;
        }

        public final Builder emojis(boolean emojis) {
            this.emojis = emojis;
            this.optBits |= 8L;
            return this;
        }

        public final Builder offsetId(long offsetId) {
            this.offsetId = offsetId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetArchivedStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetArchivedStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean masksIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean emojisIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offsetId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetArchivedStickers, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte masksBuildStage = 0;
        private boolean masks;
        private byte emojisBuildStage = 0;
        private boolean emojis;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetArchivedStickers.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetArchivedStickers.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean masks() {
            if (this.masksBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.masksBuildStage == 0) {
                this.masksBuildStage = (byte)-1;
                this.masks = ImmutableGetArchivedStickers.this.masksInitialize();
                this.masksBuildStage = 1;
            }
            return this.masks;
        }

        void masks(boolean masks) {
            this.masks = masks;
            this.masksBuildStage = 1;
        }

        boolean emojis() {
            if (this.emojisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.emojisBuildStage == 0) {
                this.emojisBuildStage = (byte)-1;
                this.emojis = ImmutableGetArchivedStickers.this.emojisInitialize();
                this.emojisBuildStage = 1;
            }
            return this.emojis;
        }

        void emojis(boolean emojis) {
            this.emojis = emojis;
            this.emojisBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.masksBuildStage == -1) {
                attributes.add("masks");
            }
            if (this.emojisBuildStage == -1) {
                attributes.add("emojis");
            }
            return "Cannot build GetArchivedStickers, attribute initializers form cycle " + attributes;
        }
    }
}

